/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core;

import org.javers.common.validation.Validate;
import org.javers.core.CommitIdGenerator;
import org.javers.core.MappingStyle;
import org.javers.core.diff.ListCompareAlgorithm;

public class JaversCoreConfiguration {
    private MappingStyle mappingStyle = MappingStyle.FIELD;
    private ListCompareAlgorithm listCompareAlgorithm = ListCompareAlgorithm.SIMPLE;
    private boolean newObjectsSnapshot = false;
    private CommitIdGenerator commitIdGenerator = CommitIdGenerator.SYNCHRONIZED_SEQUENCE;

    JaversCoreConfiguration withMappingStyle(MappingStyle mappingStyle) {
        Validate.argumentIsNotNull((Object)mappingStyle);
        this.mappingStyle = mappingStyle;
        return this;
    }

    JaversCoreConfiguration withCommitIdGenerator(CommitIdGenerator commitIdGenerator) {
        Validate.argumentIsNotNull((Object)commitIdGenerator);
        this.commitIdGenerator = commitIdGenerator;
        return this;
    }

    JaversCoreConfiguration withNewObjectsSnapshot(boolean newObjectsSnapshot) {
        this.newObjectsSnapshot = newObjectsSnapshot;
        return this;
    }

    JaversCoreConfiguration withListCompareAlgorithm(ListCompareAlgorithm algorithm) {
        this.listCompareAlgorithm = algorithm;
        return this;
    }

    public MappingStyle getMappingStyle() {
        return this.mappingStyle;
    }

    public ListCompareAlgorithm getListCompareAlgorithm() {
        return this.listCompareAlgorithm;
    }

    public boolean isNewObjectsSnapshot() {
        return this.newObjectsSnapshot;
    }

    public CommitIdGenerator getCommitIdGenerator() {
        return this.commitIdGenerator;
    }
}

