/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.type;

import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.javers.common.reflection.ReflectionUtil;
import org.javers.common.string.PrettyPrintBuilder;
import org.javers.common.string.ToStringBuilder;
import org.javers.common.validation.Validate;

public abstract class JaversType {
    public static final Class DEFAULT_TYPE_PARAMETER = Object.class;
    private final Type baseJavaType;
    private final Class baseJavaClass;
    private final List<Type> concreteTypeArguments;
    private final String name;

    JaversType(Type baseJavaType) {
        this(baseJavaType, Optional.empty());
    }

    JaversType(Type baseJavaType, Optional<String> name) {
        this(baseJavaType, name, 0);
    }

    JaversType(Type baseJavaType, Optional<String> name, int expectedArgs) {
        Validate.argumentIsNotNull(baseJavaType);
        Validate.argumentIsNotNull(name);
        this.baseJavaType = baseJavaType;
        this.baseJavaClass = ReflectionUtil.extractClass(baseJavaType);
        this.concreteTypeArguments = Collections.unmodifiableList(JaversType.buildListOfConcreteTypeArguments(baseJavaType, expectedArgs));
        this.name = name.isPresent() ? name.get() : ReflectionUtil.extractClass(baseJavaType).getName();
    }

    JaversType spawn(Type baseJavaType) {
        try {
            Constructor<?> c = this.getClass().getConstructor(Type.class);
            return (JaversType)c.newInstance(baseJavaType);
        }
        catch (ReflectiveOperationException exception) {
            throw new RuntimeException("error calling Constructor for " + this.getClass().getName(), exception);
        }
    }

    public boolean isGenericType() {
        return this.baseJavaType instanceof ParameterizedType;
    }

    public Type getBaseJavaType() {
        return this.baseJavaType;
    }

    public Class getBaseJavaClass() {
        return this.baseJavaClass;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JaversType)) {
            return false;
        }
        JaversType that = (JaversType)o;
        return this.baseJavaType.equals(that.baseJavaType);
    }

    public String toString() {
        return ToStringBuilder.toString(this, "baseType", this.baseJavaType);
    }

    public int hashCode() {
        return this.baseJavaType.hashCode();
    }

    public List<Type> getConcreteClassTypeArguments() {
        return this.concreteTypeArguments;
    }

    private static List<Type> buildListOfConcreteTypeArguments(Type baseJavaType, int expectedSize) {
        List<Type> allTypeArguments = ReflectionUtil.getAllTypeArguments(baseJavaType);
        ArrayList<Type> concreteTypeArguments = new ArrayList<Type>(expectedSize);
        for (int i = 0; i < expectedSize; ++i) {
            Type existingArgument = null;
            if (!allTypeArguments.isEmpty() && i < allTypeArguments.size()) {
                existingArgument = allTypeArguments.get(i);
            }
            concreteTypeArguments.add(JaversType.getActualClassTypeArgument(existingArgument));
        }
        return concreteTypeArguments;
    }

    private static Type getActualClassTypeArgument(Type existingArgument) {
        if (existingArgument == null) {
            return DEFAULT_TYPE_PARAMETER;
        }
        Optional<Type> concreteType = ReflectionUtil.isConcreteType(existingArgument);
        if (concreteType.isPresent()) {
            return concreteType.get();
        }
        return DEFAULT_TYPE_PARAMETER;
    }

    Type getRawDehydratedType() {
        return this.getBaseJavaClass();
    }

    public final String prettyPrint() {
        return this.prettyPrintBuilder().build();
    }

    public String getName() {
        return this.name;
    }

    public boolean isInstance(Object cdo) {
        Validate.argumentIsNotNull(cdo);
        return this.baseJavaClass.isAssignableFrom(cdo.getClass());
    }

    public boolean equals(Object left, Object right) {
        return Objects.equals(left, right);
    }

    protected PrettyPrintBuilder prettyPrintBuilder() {
        return new PrettyPrintBuilder(this).addField("baseType", this.baseJavaType).addField("typeName", this.name);
    }
}

