/*
 * Decompiled with CFR 0.152.
 */
package org.javers.shadow;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import org.javers.common.validation.Validate;
import org.javers.core.commit.CommitMetadata;
import org.javers.core.json.JsonConverter;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.core.metamodel.object.CdoSnapshotState;
import org.javers.core.metamodel.object.CdoSnapshotStateBuilder;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.object.InstanceId;
import org.javers.core.metamodel.property.Property;
import org.javers.core.metamodel.type.EnumerableType;
import org.javers.core.metamodel.type.JaversProperty;
import org.javers.core.metamodel.type.JaversType;
import org.javers.core.metamodel.type.ManagedType;
import org.javers.core.metamodel.type.ShallowReferenceType;
import org.javers.core.metamodel.type.TypeMapper;
import org.javers.shadow.ShadowBuilder;

class ShadowGraphBuilder {
    private final JsonConverter jsonConverter;
    private final BiFunction<CommitMetadata, GlobalId, CdoSnapshot> referenceResolver;
    private boolean built = false;
    private Map<GlobalId, ShadowBuilder> builtNodes = new HashMap<GlobalId, ShadowBuilder>();
    private final TypeMapper typeMapper;
    private final CommitMetadata rootContext;

    ShadowGraphBuilder(JsonConverter jsonConverter, BiFunction<CommitMetadata, GlobalId, CdoSnapshot> referenceResolver, TypeMapper typeMapper, CommitMetadata rootContext) {
        this.jsonConverter = jsonConverter;
        this.referenceResolver = referenceResolver;
        this.typeMapper = typeMapper;
        this.rootContext = rootContext;
    }

    Object buildDeepShadow(CdoSnapshot cdoSnapshot) {
        Validate.argumentIsNotNull(cdoSnapshot);
        this.switchToBuilt();
        ShadowBuilder root = this.assembleShadowStub(cdoSnapshot);
        this.doWiring();
        return root.getShadow();
    }

    private void doWiring() {
        this.builtNodes.values().forEach(ShadowBuilder::wire);
    }

    private void switchToBuilt() {
        if (this.built) {
            throw new IllegalStateException("already built");
        }
        this.built = true;
    }

    private ShadowBuilder assembleShallowReferenceShadow(InstanceId instanceId, ShallowReferenceType shallowReferenceType) {
        CdoSnapshotState state = CdoSnapshotStateBuilder.cdoSnapshotState().withPropertyValue(shallowReferenceType.getIdProperty(), instanceId.getCdoId()).build();
        JsonObject jsonElement = (JsonObject)this.jsonConverter.toJsonElement(state);
        Object shadowStub = this.jsonConverter.fromJson((JsonElement)jsonElement, shallowReferenceType.getBaseJavaClass());
        ShadowBuilder shadowBuilder = new ShadowBuilder(null, shadowStub);
        this.builtNodes.put(instanceId, shadowBuilder);
        return shadowBuilder;
    }

    private ShadowBuilder assembleShadowStub(CdoSnapshot cdoSnapshot) {
        ShadowBuilder shadowBuilder = new ShadowBuilder(cdoSnapshot, null);
        this.builtNodes.put(cdoSnapshot.getGlobalId(), shadowBuilder);
        JsonObject jsonElement = (JsonObject)this.jsonConverter.toJsonElement(cdoSnapshot.getState());
        this.followReferences(shadowBuilder, jsonElement);
        Object shadowStub = this.jsonConverter.fromJson((JsonElement)jsonElement, cdoSnapshot.getManagedType().getBaseJavaClass());
        shadowBuilder.withStub(shadowStub);
        return shadowBuilder;
    }

    private void followReferences(ShadowBuilder currentNode, JsonObject jsonElement) {
        CdoSnapshot cdoSnapshot = currentNode.getCdoSnapshot();
        cdoSnapshot.getManagedType().forEachProperty(property -> {
            Object containerWithRefs;
            EnumerableType propertyType;
            if (cdoSnapshot.isNull((Property)property)) {
                return;
            }
            if (property.getType() instanceof ManagedType) {
                GlobalId refId = (GlobalId)cdoSnapshot.getPropertyValue((Property)property);
                ShadowBuilder target = this.createOrReuseNodeFromRef(refId, (JaversType)property.getType());
                if (target != null) {
                    currentNode.addReferenceWiring((JaversProperty)property, target);
                }
                jsonElement.remove(property.getName());
            }
            if ((this.typeMapper.isContainerOfManagedTypes((JaversType)property.getType()) || this.typeMapper.isKeyValueTypeWithManagedTypes((JaversType)property.getType())) && !(propertyType = (EnumerableType)property.getType()).isEmpty(containerWithRefs = cdoSnapshot.getPropertyValue((Property)property))) {
                currentNode.addEnumerableWiring((JaversProperty)property, propertyType.map(containerWithRefs, value -> this.passValueOrCreateNodeFromRef(value, propertyType)));
                jsonElement.remove(property.getName());
            }
        });
    }

    private Object passValueOrCreateNodeFromRef(Object value, JaversType propertyType) {
        if (value instanceof GlobalId) {
            return this.createOrReuseNodeFromRef((GlobalId)value, propertyType);
        }
        return value;
    }

    private ShadowBuilder createOrReuseNodeFromRef(GlobalId globalId, JaversType propertyType) {
        if (this.builtNodes.containsKey(globalId)) {
            return this.builtNodes.get(globalId);
        }
        if (propertyType instanceof ShallowReferenceType) {
            return this.assembleShallowReferenceShadow((InstanceId)globalId, (ShallowReferenceType)propertyType);
        }
        CdoSnapshot cdoSnapshot = this.referenceResolver.apply(this.rootContext, globalId);
        if (cdoSnapshot != null) {
            return this.assembleShadowStub(cdoSnapshot);
        }
        return null;
    }
}

