/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.object;

import org.javers.common.collections.EnumerableFunction;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.object.EnumerationAwareOwnerContext;
import org.javers.core.metamodel.object.GlobalIdFactory;
import org.javers.core.metamodel.type.MapContentType;
import org.javers.core.metamodel.type.MapEnumerationOwnerContext;

public class DehydrateMapFunction
implements EnumerableFunction {
    private final GlobalIdFactory globalIdFactory;
    private final MapContentType mapContentType;

    public DehydrateMapFunction(GlobalIdFactory globalIdFactory, MapContentType mapContentType) {
        Validate.argumentsAreNotNull(globalIdFactory, mapContentType);
        this.globalIdFactory = globalIdFactory;
        this.mapContentType = mapContentType;
    }

    public Object apply(Object input, EnumerationAwareOwnerContext context) {
        MapEnumerationOwnerContext mapContext = (MapEnumerationOwnerContext)context;
        if (mapContext.isKey()) {
            return this.globalIdFactory.dehydrate(input, this.mapContentType.getKeyType(), context);
        }
        return this.globalIdFactory.dehydrate(input, this.mapContentType.getValueType(), context);
    }
}

