/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.diff.appenders.levenshtein;

import java.util.List;
import java.util.Objects;
import org.javers.common.validation.Validate;
import org.javers.core.diff.EqualsFunction;
import org.javers.core.diff.NodePair;
import org.javers.core.diff.appenders.CorePropertyChangeAppender;
import org.javers.core.diff.appenders.levenshtein.Backtrack;
import org.javers.core.diff.appenders.levenshtein.BacktrackSteps;
import org.javers.core.diff.appenders.levenshtein.StepsToChanges;
import org.javers.core.diff.changetype.container.ContainerElementChange;
import org.javers.core.diff.changetype.container.ListChange;
import org.javers.core.metamodel.object.DehydrateContainerFunction;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.object.GlobalIdFactory;
import org.javers.core.metamodel.object.PropertyOwnerContext;
import org.javers.core.metamodel.property.Property;
import org.javers.core.metamodel.type.JaversProperty;
import org.javers.core.metamodel.type.JaversType;
import org.javers.core.metamodel.type.ListType;
import org.javers.core.metamodel.type.TypeMapper;

public class LevenshteinListChangeAppender
extends CorePropertyChangeAppender<ListChange> {
    private final TypeMapper typeMapper;
    private final GlobalIdFactory globalIdFactory;

    LevenshteinListChangeAppender(TypeMapper typeMapper, GlobalIdFactory globalIdFactory) {
        Validate.argumentsAreNotNull(typeMapper, globalIdFactory);
        this.typeMapper = typeMapper;
        this.globalIdFactory = globalIdFactory;
    }

    @Override
    public boolean supports(JaversType propertyType) {
        return propertyType instanceof ListType;
    }

    @Override
    public ListChange calculateChanges(NodePair pair, JaversProperty property) {
        ListType listType = (ListType)property.getType();
        JaversType itemType = this.typeMapper.getJaversType(listType.getItemType());
        DehydrateContainerFunction dehydrateFunction = new DehydrateContainerFunction(itemType, this.globalIdFactory);
        PropertyOwnerContext owner = new PropertyOwnerContext(pair.getGlobalId(), property.getName());
        List leftList = (List)listType.map(pair.getLeftPropertyValueAndCast(property, List.class), dehydrateFunction, owner);
        List rightList = (List)listType.map(pair.getRightPropertyValueAndCast(property, List.class), dehydrateFunction, owner);
        EqualsFunction equalsFunction = (left, right) -> Objects.equals(left, right);
        Backtrack backtrack = new Backtrack(equalsFunction);
        StepsToChanges stepsToChanges = new StepsToChanges(equalsFunction);
        BacktrackSteps[][] steps = backtrack.evaluateSteps(leftList, rightList);
        List<ContainerElementChange> changes = stepsToChanges.convert(steps, leftList, rightList);
        ListChange result = this.getListChange(pair.getGlobalId(), property, changes);
        if (result != null) {
            this.renderNotParametrizedWarningIfNeeded(listType.getItemType(), "item", "List", property);
        }
        return result;
    }

    private ListChange getListChange(GlobalId affectedCdoId, Property property, List<ContainerElementChange> changes) {
        ListChange result = changes.size() == 0 ? null : new ListChange(affectedCdoId, property.getName(), changes);
        return result;
    }
}

