/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.graph;

import java.util.Optional;
import org.javers.core.graph.CdoFactory;
import org.javers.core.graph.LazyCdoWrapper;
import org.javers.core.graph.LiveCdoWrapper;
import org.javers.core.graph.ObjectAccessHook;
import org.javers.core.graph.ObjectAccessProxy;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.object.GlobalIdFactory;
import org.javers.core.metamodel.object.LiveCdo;
import org.javers.core.metamodel.object.OwnerContext;
import org.javers.core.metamodel.type.ManagedType;
import org.javers.core.metamodel.type.TypeMapper;

public class LiveCdoFactory
implements CdoFactory {
    private final GlobalIdFactory globalIdFactory;
    private ObjectAccessHook objectAccessHook;
    private TypeMapper typeMapper;

    public LiveCdoFactory(GlobalIdFactory globalIdFactory, ObjectAccessHook objectAccessHook, TypeMapper typeMapper) {
        this.globalIdFactory = globalIdFactory;
        this.objectAccessHook = objectAccessHook;
        this.typeMapper = typeMapper;
    }

    @Override
    public LiveCdo create(Object cdo, OwnerContext owner) {
        GlobalId globalId = this.globalIdFactory.createId(cdo, owner);
        Optional<ObjectAccessProxy<Object>> objectAccessor = this.objectAccessHook.createAccessor(cdo);
        Class<?> targetClass = objectAccessor.map(p -> p.getTargetClass()).orElse(cdo.getClass());
        ManagedType managedType = this.typeMapper.getJaversManagedType(targetClass);
        if (objectAccessor.isPresent()) {
            return new LazyCdoWrapper(objectAccessor.get().getObjectSupplier(), globalId, managedType);
        }
        return new LiveCdoWrapper(cdo, globalId, managedType);
    }

    @Override
    public String typeDesc() {
        return "live";
    }
}

