/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.jql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.javers.common.collections.Pair;
import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.repository.jql.JqlQuery;
import org.javers.repository.jql.ShadowQueryRunner;
import org.javers.shadow.Shadow;

class ShadowStreamQueryRunner {
    private final ShadowQueryRunner shadowQueryRunner;

    ShadowStreamQueryRunner(ShadowQueryRunner shadowQueryRunner) {
        this.shadowQueryRunner = shadowQueryRunner;
    }

    Stream<Shadow> queryForShadowsStream(JqlQuery query) {
        if (query.getQueryParams().skip() > 0) {
            throw new JaversException(JaversExceptionCode.MALFORMED_JQL, "skip can't be set on a JqlStreamQuery. Use Stream.skip() on a resulting Stream.");
        }
        int characteristics = 1040;
        StreamQuery streamQuery = new StreamQuery(query);
        Spliterator<Shadow> spliterator = Spliterators.spliteratorUnknownSize(streamQuery.lazyIterator(), characteristics);
        Stream<Shadow> stream = StreamSupport.stream(spliterator, false);
        return stream;
    }

    class StreamQuery {
        private JqlQuery awaitingQuery;
        private final List<JqlQuery> queries = new ArrayList<JqlQuery>();
        private final List<CdoSnapshot> filledGapsSnapshots = new ArrayList<CdoSnapshot>();

        StreamQuery(JqlQuery initialQuery) {
            Validate.argumentIsNotNull(initialQuery);
            this.awaitingQuery = initialQuery;
        }

        List<Shadow> loadNextPage() {
            JqlQuery currentQuery = this.awaitingQuery;
            Pair<List<Shadow>, List<CdoSnapshot>> result = ShadowStreamQueryRunner.this.shadowQueryRunner.queryForShadows(currentQuery, this.filledGapsSnapshots);
            this.queries.add(currentQuery);
            this.queries.get(0).appendNextStatsForStream(currentQuery.stats());
            this.filledGapsSnapshots.addAll((Collection<CdoSnapshot>)result.right());
            this.awaitingQuery = currentQuery.nextQueryForStream();
            return result.left();
        }

        Iterator<Shadow> lazyIterator() {
            return new LazyIterator();
        }

        class LazyIterator
        implements Iterator<Shadow> {
            private boolean terminated = false;
            private List<Shadow> loadedShadows = new ArrayList<Shadow>();
            private int nextIdx = 0;

            LazyIterator() {
            }

            @Override
            public boolean hasNext() {
                if (this.terminated) {
                    return false;
                }
                if (this.shouldLoadNextPage()) {
                    List<Shadow> nextPage = StreamQuery.this.loadNextPage();
                    if (nextPage.size() == 0) {
                        this.terminate();
                        return false;
                    }
                    this.loadedShadows.addAll(nextPage);
                }
                return !this.terminated;
            }

            private void terminate() {
                this.loadedShadows.clear();
                this.terminated = true;
            }

            private boolean shouldLoadNextPage() {
                return this.nextIdx >= this.loadedShadows.size();
            }

            @Override
            public Shadow next() {
                if (this.terminated) {
                    throw new IllegalStateException("attempt to read from the terminated iterator");
                }
                Shadow result = this.loadedShadows.get(this.nextIdx);
                ++this.nextIdx;
                return result;
            }
        }
    }
}

