/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.diff.changetype.container;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.javers.common.validation.Validate;
import org.javers.core.commit.CommitMetadata;
import org.javers.core.diff.changetype.container.CollectionChange;
import org.javers.core.diff.changetype.container.ContainerElementChange;
import org.javers.core.diff.changetype.container.ValueAddOrRemove;
import org.javers.core.metamodel.object.GlobalId;

public final class SetChange
extends CollectionChange {
    public SetChange(GlobalId affectedCdoId, String propertyName, List<ContainerElementChange> changes) {
        this(affectedCdoId, propertyName, changes, Optional.empty());
    }

    public SetChange(GlobalId affectedCdoId, String propertyName, List<ContainerElementChange> changes, Optional<CommitMetadata> commitMetadata) {
        super(affectedCdoId, propertyName, changes, commitMetadata);
        for (ContainerElementChange change : changes) {
            Validate.conditionFulfilled(change instanceof ValueAddOrRemove, "SetChange constructor failed, expected ValueAddOrRemove");
            Validate.conditionFulfilled(change.getIndex() == null, "SetChange constructor failed, expected empty change.index");
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SetChange) {
            SetChange that = (SetChange)obj;
            return super.equals(that);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode());
    }
}

