/*
 * Decompiled with CFR 0.152.
 */
package org.javers.common.collections;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.Currency;
import java.util.List;
import java.util.UUID;
import org.javers.common.collections.Lists;
import org.javers.common.reflection.ReflectionUtil;

public class WellKnownValueTypes {
    private static final List<Class<?>> VALUE_TYPES = Lists.asList(BigDecimal.class, BigInteger.class, ThreadLocal.class, UUID.class, Currency.class, URI.class, URL.class, CharSequence.class, String.class);

    public static List<Class<?>> getValueTypes() {
        return Collections.unmodifiableList(VALUE_TYPES);
    }

    public static boolean isValueType(Object object) {
        if (object == null) {
            return false;
        }
        return WellKnownValueTypes.isValueType(object.getClass());
    }

    private static boolean isValueType(Class clazz) {
        return ReflectionUtil.isAssignableFromAny(clazz, VALUE_TYPES);
    }
}

