/*
 * Decompiled with CFR 0.152.
 */
package org.javers.guava;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import java.lang.reflect.Type;
import org.javers.common.collections.EnumerableFunction;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.object.EnumerationAwareOwnerContext;
import org.javers.core.metamodel.object.OwnerContext;
import org.javers.core.metamodel.type.CollectionType;

public class MultisetType
extends CollectionType {
    public static MultisetType getInstance() {
        return new MultisetType((Type)((Object)Multiset.class));
    }

    public MultisetType(Type baseJavaType) {
        super(baseJavaType);
    }

    @Override
    public Object map(Object sourceMultiset_, EnumerableFunction mapFunction, OwnerContext owner) {
        Validate.argumentIsNotNull(mapFunction);
        Multiset sourceMultiset = this.toNotNullMultiset(sourceMultiset_);
        HashMultiset targetMultiset = HashMultiset.create();
        EnumerationAwareOwnerContext enumeratorContext = new EnumerationAwareOwnerContext(owner, true);
        for (Object sourceVal : sourceMultiset) {
            targetMultiset.add(mapFunction.apply(sourceVal, enumeratorContext));
        }
        return Multisets.unmodifiableMultiset((Multiset)targetMultiset);
    }

    private Multiset toNotNullMultiset(Object sourceSet) {
        if (sourceSet == null) {
            return HashMultiset.create();
        }
        return (Multiset)sourceSet;
    }
}

