/*
 * Decompiled with CFR 0.152.
 */
package org.javers.guava;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collections;
import java.util.Set;
import org.javers.common.collections.Sets;

class Multimaps {
    Multimaps() {
    }

    public static <K, V> Set<K> commonKeys(Multimap<K, V> left, Multimap<K, V> right) {
        if (left == null || right == null) {
            return Collections.emptySet();
        }
        return Sets.intersection(left.keySet(), right.keySet());
    }

    public static <K, V> Set<K> keysDifference(Multimap<K, V> left, Multimap<K, V> right) {
        if (left == null) {
            return Collections.emptySet();
        }
        if (right == null) {
            return left.keySet();
        }
        return Sets.difference(left.keySet(), right.keySet());
    }

    public static Multimap createEmptyMultimap(Object sourceMap) {
        if (sourceMap instanceof ListMultimap) {
            return ArrayListMultimap.create();
        }
        return HashMultimap.create();
    }

    public static Multimap toNotNullMultimap(Object sourceMap) {
        if (sourceMap == null) {
            return ArrayListMultimap.create();
        }
        return (Multimap)sourceMap;
    }
}

