/*
 * Decompiled with CFR 0.152.
 */
package org.javers.guava;

import com.google.common.collect.Multimap;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import org.javers.common.collections.EnumerableFunction;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.object.OwnerContext;
import org.javers.core.metamodel.type.KeyValueType;
import org.javers.core.metamodel.type.MapEnumerationOwnerContext;
import org.javers.guava.Multimaps;

public class MultimapType
extends KeyValueType {
    public static MultimapType getInstance() {
        return new MultimapType((Type)((Object)Multimap.class));
    }

    public MultimapType(Type baseJavaType) {
        super(baseJavaType, 2);
    }

    public Multimap map(Object sourceMap_, EnumerableFunction mapFunction, OwnerContext owner) {
        Validate.argumentIsNotNull(mapFunction);
        Multimap sourceMultimap = Multimaps.toNotNullMultimap(sourceMap_);
        Multimap targetMultimap = Multimaps.createEmptyMultimap(sourceMap_);
        MapEnumerationOwnerContext enumeratorContext = new MapEnumerationOwnerContext(owner, true);
        Collection entries = sourceMultimap.entries();
        for (Map.Entry entry : entries) {
            enumeratorContext.switchToKey();
            Object mappedKey = mapFunction.apply(entry.getKey(), enumeratorContext);
            enumeratorContext.switchToValue(mappedKey);
            Object value = entry.getValue();
            Object mappedValue = mapFunction.apply(value, enumeratorContext);
            targetMultimap.put(mappedKey, mappedValue);
        }
        return com.google.common.collect.Multimaps.unmodifiableMultimap((Multimap)targetMultimap);
    }

    @Override
    public boolean isEmpty(Object container) {
        return container == null || ((Multimap)container).isEmpty();
    }
}

