/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.snapshot;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.javers.common.collections.Sets;
import org.javers.common.validation.Validate;
import org.javers.core.commit.CommitMetadata;
import org.javers.core.diff.Change;
import org.javers.core.diff.Diff;
import org.javers.core.diff.DiffFactory;
import org.javers.core.diff.changetype.NewObject;
import org.javers.core.diff.changetype.ObjectRemoved;
import org.javers.core.graph.ObjectNode;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.core.metamodel.object.CdoSnapshotBuilder;
import org.javers.core.snapshot.ShadowGraph;
import org.javers.repository.api.SnapshotIdentifier;

public class SnapshotDiffer {
    private final DiffFactory diffFactory;

    public SnapshotDiffer(DiffFactory diffFactory) {
        this.diffFactory = diffFactory;
    }

    public List<Change> calculateDiffs(List<CdoSnapshot> snapshots, Map<SnapshotIdentifier, CdoSnapshot> previousSnapshots) {
        Validate.argumentsAreNotNull(snapshots);
        Validate.argumentsAreNotNull(previousSnapshots);
        ArrayList<Change> changes = new ArrayList<Change>();
        for (CdoSnapshot snapshot : snapshots) {
            if (snapshot.isInitial()) {
                this.addInitialChanges(changes, snapshot);
                continue;
            }
            if (snapshot.isTerminal()) {
                this.addTerminalChanges(changes, snapshot);
                continue;
            }
            CdoSnapshot previousSnapshot = previousSnapshots.get(SnapshotIdentifier.from(snapshot).previous());
            this.addChanges(changes, previousSnapshot, snapshot);
        }
        return changes;
    }

    private void addInitialChanges(List<Change> changes, CdoSnapshot initialSnapshot) {
        CdoSnapshot emptySnapshot = CdoSnapshotBuilder.emptyCopyOf(initialSnapshot);
        Diff diff = this.diffFactory.create(this.shadowGraph(emptySnapshot), this.shadowGraph(initialSnapshot), this.commitMetadata(initialSnapshot));
        NewObject newObjectChange = new NewObject(initialSnapshot.getGlobalId(), Optional.empty(), Optional.of(initialSnapshot.getCommitMetadata()));
        changes.addAll(diff.getChanges());
        changes.add(newObjectChange);
    }

    private void addTerminalChanges(List<Change> changes, CdoSnapshot terminalSnapshot) {
        changes.add(new ObjectRemoved(terminalSnapshot.getGlobalId(), Optional.empty(), Optional.of(terminalSnapshot.getCommitMetadata())));
    }

    private void addChanges(List<Change> changes, CdoSnapshot previousSnapshot, CdoSnapshot currentSnapshot) {
        Diff diff = this.diffFactory.create(this.shadowGraph(previousSnapshot), this.shadowGraph(currentSnapshot), this.commitMetadata(currentSnapshot));
        changes.addAll(diff.getChanges());
    }

    private ShadowGraph shadowGraph(CdoSnapshot snapshot) {
        return new ShadowGraph(Sets.asSet(new ObjectNode(snapshot)));
    }

    private Optional<CommitMetadata> commitMetadata(CdoSnapshot snapshot) {
        return Optional.of(snapshot.getCommitMetadata());
    }
}

