/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.scanner;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.javers.common.reflection.JaversField;
import org.javers.common.reflection.ReflectionUtil;
import org.javers.core.metamodel.property.Property;
import org.javers.core.metamodel.scanner.AnnotationNamesProvider;
import org.javers.core.metamodel.scanner.PropertyScan;
import org.javers.core.metamodel.scanner.PropertyScanner;

class FieldBasedPropertyScanner
extends PropertyScanner {
    private final AnnotationNamesProvider annotationNamesProvider;

    public FieldBasedPropertyScanner(AnnotationNamesProvider annotationNamesProvider) {
        this.annotationNamesProvider = annotationNamesProvider;
    }

    @Override
    public PropertyScan scan(Class<?> managedClass, boolean ignoreDeclaredProperties) {
        List<JaversField> fields = ReflectionUtil.getAllPersistentFields(managedClass);
        ArrayList<Property> propertyList = new ArrayList<Property>(fields.size());
        for (JaversField field : fields) {
            boolean isIgnoredInType = ignoreDeclaredProperties && field.getDeclaringClass().equals(managedClass);
            boolean hasTransientAnn = this.annotationNamesProvider.hasTransientPropertyAnn(field.getAnnotationTypes());
            boolean hasShallowReferenceAnn = this.annotationNamesProvider.hasShallowReferenceAnn(field.getAnnotationTypes());
            Optional<String> customPropertyName = this.annotationNamesProvider.findPropertyNameAnnValue(field.getAnnotations());
            propertyList.add(new Property(field, hasTransientAnn || isIgnoredInType, hasShallowReferenceAnn, customPropertyName));
        }
        return new PropertyScan(propertyList);
    }
}

