/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.commit;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.javers.common.collections.Lists;
import org.javers.common.date.DateProvider;
import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.common.validation.Validate;
import org.javers.core.commit.Commit;
import org.javers.core.commit.CommitIdFactory;
import org.javers.core.commit.CommitMetadata;
import org.javers.core.diff.Diff;
import org.javers.core.diff.DiffFactory;
import org.javers.core.graph.LiveGraph;
import org.javers.core.graph.LiveGraphFactory;
import org.javers.core.metamodel.object.Cdo;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.snapshot.GraphSnapshotFacade;
import org.javers.core.snapshot.ShadowGraph;
import org.javers.core.snapshot.SnapshotFactory;
import org.javers.repository.api.JaversExtendedRepository;

public class CommitFactory {
    private final DiffFactory diffFactory;
    private final JaversExtendedRepository javersRepository;
    private final DateProvider dateProvider;
    private final GraphSnapshotFacade graphSnapshotFacade;
    private final LiveGraphFactory liveGraphFactory;
    private final SnapshotFactory snapshotFactory;
    private final CommitIdFactory commitIdFactory;

    public CommitFactory(DiffFactory diffFactory, JaversExtendedRepository javersRepository, DateProvider dateProvider, GraphSnapshotFacade graphSnapshotFacade, LiveGraphFactory liveGraphFactory, SnapshotFactory snapshotFactory, CommitIdFactory commitIdFactory) {
        this.diffFactory = diffFactory;
        this.javersRepository = javersRepository;
        this.dateProvider = dateProvider;
        this.graphSnapshotFacade = graphSnapshotFacade;
        this.liveGraphFactory = liveGraphFactory;
        this.snapshotFactory = snapshotFactory;
        this.commitIdFactory = commitIdFactory;
    }

    public Commit createTerminalByGlobalId(String author, Map<String, String> properties, GlobalId removedId) {
        Validate.argumentsAreNotNull(author, properties, removedId);
        Optional<CdoSnapshot> previousSnapshot = this.javersRepository.getLatest(removedId);
        CommitMetadata commitMetadata = this.nextCommit(author, properties);
        CdoSnapshot terminalSnapshot = previousSnapshot.map(prev -> this.snapshotFactory.createTerminal(removedId, (CdoSnapshot)prev, commitMetadata)).orElseThrow(() -> new JaversException(JaversExceptionCode.CANT_DELETE_OBJECT_NOT_FOUND, removedId.value()));
        Diff diff = this.diffFactory.singleTerminal(removedId, commitMetadata);
        return new Commit(commitMetadata, Lists.asList(terminalSnapshot), diff);
    }

    public Commit createTerminal(String author, Map<String, String> properties, Object removed) {
        Validate.argumentsAreNotNull(author, properties, removed);
        Cdo removedCdo = this.liveGraphFactory.createCdo(removed);
        return this.createTerminalByGlobalId(author, properties, removedCdo.getGlobalId());
    }

    public Commit create(String author, Map<String, String> properties, Object currentVersion) {
        Validate.argumentsAreNotNull(author, currentVersion);
        CommitMetadata commitMetadata = this.nextCommit(author, properties);
        LiveGraph currentGraph = this.liveGraphFactory.createLiveGraph(currentVersion);
        ShadowGraph latestShadowGraph = this.graphSnapshotFacade.createLatestShadow(currentGraph);
        List<CdoSnapshot> snapshots = this.graphSnapshotFacade.createGraphSnapshot(currentGraph, latestShadowGraph, commitMetadata);
        Diff diff = this.diffFactory.create(latestShadowGraph, currentGraph, Optional.of(commitMetadata));
        return new Commit(commitMetadata, snapshots, diff);
    }

    private CommitMetadata nextCommit(String author, Map<String, String> properties) {
        return new CommitMetadata(author, properties, this.dateProvider.now(), this.commitIdFactory.nextId());
    }
}

