/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.type;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.javers.common.collections.EnumerableFunction;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.object.EnumerationAwareOwnerContext;
import org.javers.core.metamodel.object.OwnerContext;
import org.javers.core.metamodel.type.ContainerType;

public class CollectionType
extends ContainerType {
    public CollectionType(Type baseJavaType) {
        super(baseJavaType);
    }

    @Override
    public boolean isEmpty(Object collection) {
        return collection == null || ((Collection)collection).isEmpty();
    }

    @Override
    public Object map(Object sourceCol_, EnumerableFunction mapFunction, OwnerContext owner) {
        Validate.argumentIsNotNull(mapFunction);
        Collection sourceCol = (Collection)sourceCol_;
        if (sourceCol == null || sourceCol.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet targetSet = new HashSet(sourceCol.size());
        EnumerationAwareOwnerContext enumerationContext = new EnumerationAwareOwnerContext(owner);
        for (Object sourceVal : sourceCol) {
            targetSet.add(mapFunction.apply(sourceVal, enumerationContext));
        }
        return Collections.unmodifiableSet(targetSet);
    }
}

