/*
 * Decompiled with CFR 0.152.
 */
package org.javers.common.reflection;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.javers.common.reflection.JaversMethod;
import org.javers.common.reflection.TypeResolvingContext;

class JaversMethodFactory {
    private final Class methodSource;

    public JaversMethodFactory(Class methodSource) {
        this.methodSource = methodSource;
    }

    public List<JaversMethod> getAllMethods() {
        ArrayList<JaversMethod> methods = new ArrayList<JaversMethod>();
        TypeResolvingContext context = new TypeResolvingContext();
        for (Class clazz = this.methodSource; clazz != null; clazz = clazz.getSuperclass()) {
            context.addTypeSubstitutions(clazz);
            for (Method m : clazz.getDeclaredMethods()) {
                if (m.isBridge()) continue;
                methods.add(this.createJMethod(m, context));
            }
        }
        return methods;
    }

    private JaversMethod createJMethod(Method rawMethod, TypeResolvingContext context) {
        Type actualReturnType = context.getSubstitution(rawMethod.getGenericReturnType());
        return new JaversMethod(rawMethod, actualReturnType);
    }
}

