/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.diff;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.common.validation.Validate;
import org.javers.core.JaversCoreConfiguration;
import org.javers.core.commit.CommitMetadata;
import org.javers.core.diff.Change;
import org.javers.core.diff.Diff;
import org.javers.core.diff.DiffBuilder;
import org.javers.core.diff.FakeNodePair;
import org.javers.core.diff.GraphPair;
import org.javers.core.diff.NodeMatcher;
import org.javers.core.diff.NodePair;
import org.javers.core.diff.ObjectGraph;
import org.javers.core.diff.appenders.NodeChangeAppender;
import org.javers.core.diff.appenders.PropertyChangeAppender;
import org.javers.core.diff.changetype.ObjectRemoved;
import org.javers.core.graph.LiveGraph;
import org.javers.core.graph.LiveGraphFactory;
import org.javers.core.graph.ObjectNode;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.property.Property;
import org.javers.core.metamodel.type.JaversType;
import org.javers.core.metamodel.type.PrimitiveType;
import org.javers.core.metamodel.type.TypeMapper;
import org.javers.core.metamodel.type.ValueType;

public class DiffFactory {
    private final NodeMatcher nodeMatcher = new NodeMatcher();
    private final TypeMapper typeMapper;
    private final List<NodeChangeAppender> nodeChangeAppenders;
    private final List<PropertyChangeAppender> propertyChangeAppender;
    private final LiveGraphFactory graphFactory;
    private final JaversCoreConfiguration javersCoreConfiguration;

    public DiffFactory(TypeMapper typeMapper, List<NodeChangeAppender> nodeChangeAppenders, List<PropertyChangeAppender> propertyChangeAppender, LiveGraphFactory graphFactory, JaversCoreConfiguration javersCoreConfiguration) {
        this.typeMapper = typeMapper;
        this.nodeChangeAppenders = nodeChangeAppenders;
        this.graphFactory = graphFactory;
        this.javersCoreConfiguration = javersCoreConfiguration;
        Collections.sort(propertyChangeAppender, (p1, p2) -> Integer.valueOf(p1.priority()).compareTo(p2.priority()));
        this.propertyChangeAppender = propertyChangeAppender;
    }

    public Diff compare(Object oldVersion, Object currentVersion) {
        return this.create(this.buildGraph(oldVersion), this.buildGraph(currentVersion), Optional.empty());
    }

    public <T> Diff compareCollections(Collection<T> oldVersion, Collection<T> currentVersion, Class<T> itemClass) {
        return this.create(this.buildGraph(oldVersion, itemClass), this.buildGraph(currentVersion, itemClass), Optional.empty());
    }

    private LiveGraph buildGraph(Collection handle, Class itemClass) {
        return this.graphFactory.createLiveGraph(handle, itemClass);
    }

    public Diff create(ObjectGraph leftGraph, ObjectGraph rightGraph, Optional<CommitMetadata> commitMetadata) {
        Validate.argumentsAreNotNull(leftGraph, rightGraph);
        GraphPair graphPair = new GraphPair(leftGraph, rightGraph);
        return this.createAndAppendChanges(graphPair, commitMetadata);
    }

    public Diff singleTerminal(GlobalId removedId, CommitMetadata commitMetadata) {
        Validate.argumentsAreNotNull(removedId, commitMetadata);
        DiffBuilder diff = DiffBuilder.diff();
        diff.addChange(new ObjectRemoved(removedId, Optional.empty(), Optional.of(commitMetadata)));
        return diff.build();
    }

    public Diff initial(Object newDomainObject) {
        Validate.argumentIsNotNull(newDomainObject);
        LiveGraph currentGraph = this.buildGraph(newDomainObject);
        GraphPair graphPair = new GraphPair(currentGraph);
        return this.createAndAppendChanges(graphPair, Optional.empty());
    }

    private LiveGraph buildGraph(Object handle) {
        JaversType jType = this.typeMapper.getJaversType(handle.getClass());
        if (jType instanceof ValueType || jType instanceof PrimitiveType) {
            throw new JaversException(JaversExceptionCode.COMPARING_TOP_LEVEL_VALUES_NOT_SUPPORTED, jType.getClass().getSimpleName(), handle.getClass().getSimpleName());
        }
        return this.graphFactory.createLiveGraph(handle);
    }

    private Diff createAndAppendChanges(GraphPair graphPair, Optional<CommitMetadata> commitMetadata) {
        DiffBuilder diff = DiffBuilder.diff();
        for (NodeChangeAppender appender : this.nodeChangeAppenders) {
            diff.addChanges(appender.getChangeSet(graphPair), commitMetadata);
        }
        if (this.javersCoreConfiguration.isNewObjectsSnapshot()) {
            for (ObjectNode node : graphPair.getOnlyOnRight()) {
                FakeNodePair pair = new FakeNodePair(node);
                this.appendPropertyChanges(diff, pair, commitMetadata);
            }
        }
        for (NodePair pair : this.nodeMatcher.match(graphPair)) {
            this.appendPropertyChanges(diff, pair, commitMetadata);
        }
        return diff.build();
    }

    private void appendPropertyChanges(DiffBuilder diff, NodePair pair, Optional<CommitMetadata> commitMetadata) {
        List<Property> nodeProperties = pair.getProperties();
        for (Property property : nodeProperties) {
            if (pair.isNullOnBothSides(property)) continue;
            Object javersType = this.typeMapper.getPropertyType(property);
            this.appendChanges(diff, pair, property, (JaversType)javersType, commitMetadata);
        }
    }

    private void appendChanges(DiffBuilder diff, NodePair pair, Property property, JaversType javersType, Optional<CommitMetadata> commitMetadata) {
        for (PropertyChangeAppender appender : this.propertyChangeAppender) {
            if (!appender.supports(javersType)) continue;
            Object change = appender.calculateChanges(pair, property);
            if (change == null) break;
            diff.addChange((Change)change, pair.getRight().wrappedCdo());
            commitMetadata.ifPresent(cm -> change.bindToCommit((CommitMetadata)cm));
            break;
        }
    }
}

