/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.diff;

import java.util.Collections;
import java.util.Set;
import org.javers.common.collections.Sets;
import org.javers.core.diff.ObjectGraph;
import org.javers.core.graph.ObjectNode;

public class GraphPair {
    private final ObjectGraph leftGraph;
    private final ObjectGraph rightGraph;
    private final Set<ObjectNode> onlyOnLeft;
    private final Set<ObjectNode> onlyOnRight;

    public GraphPair(ObjectGraph leftGraph, ObjectGraph rightGraph) {
        this.leftGraph = leftGraph;
        this.rightGraph = rightGraph;
        this.onlyOnLeft = Sets.difference(leftGraph.nodes(), rightGraph.nodes());
        this.onlyOnRight = Sets.difference(rightGraph.nodes(), leftGraph.nodes());
    }

    public GraphPair(ObjectGraph currentGraph) {
        this.leftGraph = new EmptyGraph();
        this.rightGraph = currentGraph;
        this.onlyOnLeft = Collections.emptySet();
        this.onlyOnRight = this.rightGraph.nodes();
    }

    public Set<ObjectNode> getOnlyOnLeft() {
        return this.onlyOnLeft;
    }

    public Set<ObjectNode> getOnlyOnRight() {
        return this.onlyOnRight;
    }

    public Set<ObjectNode> getLeftNodeSet() {
        return this.leftGraph.nodes();
    }

    public Set<ObjectNode> getRightNodeSet() {
        return this.rightGraph.nodes();
    }

    private class EmptyGraph
    implements ObjectGraph {
        private EmptyGraph() {
        }

        @Override
        public Set<ObjectNode> nodes() {
            return Collections.emptySet();
        }

        @Override
        public ObjectNode root() {
            throw new RuntimeException("not implemented");
        }
    }
}

