/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.snapshot;

import java.util.Collections;
import java.util.Set;
import org.javers.common.collections.Optional;
import org.javers.core.diff.ObjectGraph;
import org.javers.core.graph.ObjectNode;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.core.metamodel.object.GlobalId;

public class ShadowGraph
implements ObjectGraph {
    private final Set<ObjectNode> snapshots;
    public static ShadowGraph EMPTY = new ShadowGraph(Collections.emptySet());

    ShadowGraph(Set<ObjectNode> snapshots) {
        this.snapshots = snapshots;
    }

    @Override
    public Set<ObjectNode> nodes() {
        return Collections.unmodifiableSet(this.snapshots);
    }

    @Override
    public ObjectNode root() {
        throw new RuntimeException("not implemented");
    }

    boolean contains(ObjectNode node) {
        return this.snapshots.contains(node);
    }

    Optional<CdoSnapshot> get(GlobalId globalId) {
        for (ObjectNode node : this.snapshots) {
            if (!globalId.equals(node.getGlobalId())) continue;
            return Optional.of((CdoSnapshot)node.getCdo());
        }
        return Optional.empty();
    }
}

