/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.diff.changetype.container;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.javers.common.collections.Function;
import org.javers.common.collections.Lists;
import org.javers.common.collections.Predicate;
import org.javers.common.string.ToStringBuilder;
import org.javers.common.validation.Validate;
import org.javers.core.diff.changetype.PropertyChange;
import org.javers.core.diff.changetype.container.ContainerElementChange;
import org.javers.core.diff.changetype.container.ValueAdded;
import org.javers.core.diff.changetype.container.ValueRemoved;
import org.javers.core.metamodel.object.GlobalId;

public abstract class ContainerChange
extends PropertyChange {
    private final List<ContainerElementChange> changes;

    ContainerChange(GlobalId affectedCdoId, String propertyName, List<ContainerElementChange> changes) {
        super(affectedCdoId, propertyName);
        Validate.argumentIsNotNull(changes);
        Validate.argumentCheck(!changes.isEmpty(), "changes list should not be empty");
        this.changes = Collections.unmodifiableList(new ArrayList<ContainerElementChange>(changes));
    }

    public List<ContainerElementChange> getChanges() {
        return this.changes;
    }

    public List<ValueAdded> getValueAddedChanges() {
        return Lists.positiveFilter(this.changes, new Predicate<ContainerElementChange>(){

            @Override
            public boolean apply(ContainerElementChange input) {
                return input instanceof ValueAdded;
            }
        });
    }

    public List<ValueRemoved> getValueRemovedChanges() {
        return Lists.positiveFilter(this.changes, new Predicate<ContainerElementChange>(){

            @Override
            public boolean apply(ContainerElementChange input) {
                return input instanceof ValueRemoved;
            }
        });
    }

    public List<?> getAddedValues() {
        return Lists.transform(this.getValueAddedChanges(), new Function<ValueAdded, Object>(){

            @Override
            public Object apply(ValueAdded input) {
                return input.getAddedValue();
            }
        });
    }

    public List<?> getRemovedValues() {
        return Lists.transform(this.getValueRemovedChanges(), new Function<ValueRemoved, Object>(){

            @Override
            public Object apply(ValueRemoved input) {
                return input.getRemovedValue();
            }
        });
    }

    @Override
    protected String fieldsToString() {
        StringBuilder changesAsString = new StringBuilder();
        for (ContainerElementChange c : this.changes) {
            if (changesAsString.length() > 0) {
                changesAsString.append(", ");
            }
            changesAsString.append(c);
        }
        return super.fieldsToString() + ToStringBuilder.addEnumField("containerChanges", changesAsString);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ContainerChange) {
            ContainerChange that = (ContainerChange)obj;
            return super.equals(that) && Objects.equals(this.changes, that.changes);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.changes);
    }
}

