/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.javers.common.collections.Optional;
import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.common.validation.Validate;
import org.javers.core.IdBuilder;
import org.javers.core.Javers;
import org.javers.core.changelog.ChangeListTraverser;
import org.javers.core.changelog.ChangeProcessor;
import org.javers.core.commit.Commit;
import org.javers.core.commit.CommitFactory;
import org.javers.core.diff.Change;
import org.javers.core.diff.Diff;
import org.javers.core.diff.DiffFactory;
import org.javers.core.diff.changetype.PropertyChange;
import org.javers.core.json.JsonConverter;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.core.metamodel.object.GlobalIdFactory;
import org.javers.core.metamodel.property.Property;
import org.javers.core.metamodel.type.JaversType;
import org.javers.core.metamodel.type.ManagedType;
import org.javers.core.metamodel.type.PrimitiveType;
import org.javers.core.metamodel.type.TypeMapper;
import org.javers.core.metamodel.type.ValueType;
import org.javers.repository.api.JaversExtendedRepository;
import org.javers.repository.jql.GlobalIdDTO;
import org.javers.repository.jql.InstanceIdDTO;
import org.javers.repository.jql.JqlQuery;
import org.javers.repository.jql.QueryRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JaversCore
implements Javers {
    private static final Logger logger = LoggerFactory.getLogger(Javers.class);
    private final DiffFactory diffFactory;
    private final TypeMapper typeMapper;
    private final JsonConverter jsonConverter;
    private final CommitFactory commitFactory;
    private final JaversExtendedRepository repository;
    private final QueryRunner queryRunner;
    private final GlobalIdFactory globalIdFactory;

    JaversCore(DiffFactory diffFactory, TypeMapper typeMapper, JsonConverter jsonConverter, CommitFactory commitFactory, JaversExtendedRepository repository, QueryRunner queryRunner, GlobalIdFactory globalIdFactory) {
        this.diffFactory = diffFactory;
        this.typeMapper = typeMapper;
        this.jsonConverter = jsonConverter;
        this.commitFactory = commitFactory;
        this.repository = repository;
        this.queryRunner = queryRunner;
        this.globalIdFactory = globalIdFactory;
    }

    @Override
    public Commit commit(String author, Object currentVersion) {
        return this.commit(author, currentVersion, Collections.emptyMap());
    }

    @Override
    public Commit commit(String author, Object currentVersion, Map<String, String> commitProperties) {
        long start = System.currentTimeMillis();
        Validate.argumentsAreNotNull(author, commitProperties, currentVersion);
        JaversType jType = this.typeMapper.getJaversType(currentVersion.getClass());
        if (jType instanceof ValueType || jType instanceof PrimitiveType) {
            throw new JaversException(JaversExceptionCode.COMMITTING_TOP_LEVEL_VALUES_NOT_SUPPORTED, jType.getClass().getSimpleName(), currentVersion.getClass().getSimpleName());
        }
        Commit commit = this.commitFactory.create(author, commitProperties, currentVersion);
        long stop_f = System.currentTimeMillis();
        this.repository.persist(commit);
        long stop = System.currentTimeMillis();
        logger.info(commit.toString() + ", done in " + (stop - start) + " millis (factory:{}, persist:{})", (Object)(stop_f - start), (Object)(stop - stop_f));
        return commit;
    }

    @Override
    public Commit commitShallowDelete(String author, Object deleted) {
        return this.commitShallowDelete(author, deleted, Collections.emptyMap());
    }

    @Override
    public Commit commitShallowDelete(String author, Object deleted, Map<String, String> properties) {
        Validate.argumentsAreNotNull(author, properties, deleted);
        Commit commit = this.commitFactory.createTerminal(author, properties, deleted);
        this.repository.persist(commit);
        logger.info(commit.toString());
        return commit;
    }

    @Override
    public Commit commitShallowDeleteById(String author, GlobalIdDTO globalId) {
        return this.commitShallowDeleteById(author, globalId, Collections.emptyMap());
    }

    @Override
    public Commit commitShallowDeleteById(String author, GlobalIdDTO globalId, Map<String, String> properties) {
        Validate.argumentsAreNotNull(author, properties, globalId);
        Commit commit = this.commitFactory.createTerminalByGlobalId(author, properties, this.globalIdFactory.createFromDto(globalId));
        this.repository.persist(commit);
        logger.info(commit.toString());
        return commit;
    }

    @Override
    public Diff compare(Object oldVersion, Object currentVersion) {
        Validate.argumentsAreNotNull(oldVersion, currentVersion);
        return this.diffFactory.compare(oldVersion, currentVersion);
    }

    @Override
    public Diff initial(Object newDomainObject) {
        return this.diffFactory.initial(newDomainObject);
    }

    @Override
    public List<CdoSnapshot> findSnapshots(JqlQuery query) {
        return this.queryRunner.queryForSnapshots(query);
    }

    @Override
    public List<Change> findChanges(JqlQuery query) {
        return this.queryRunner.queryForChanges(query);
    }

    @Override
    public Optional<CdoSnapshot> getLatestSnapshot(Object localId, Class entityClass) {
        Validate.argumentsAreNotNull(localId, entityClass);
        return this.queryRunner.runQueryForLatestSnapshot(InstanceIdDTO.instanceId(localId, entityClass));
    }

    @Override
    public JsonConverter getJsonConverter() {
        return this.jsonConverter;
    }

    @Override
    public <T> T processChangeList(List<Change> changes, ChangeProcessor<T> changeProcessor) {
        Validate.argumentsAreNotNull(changes, changeProcessor);
        ChangeListTraverser.traverse(changes, changeProcessor);
        return changeProcessor.result();
    }

    @Override
    public IdBuilder idBuilder() {
        return new IdBuilder(this.globalIdFactory);
    }

    @Override
    public <T extends JaversType> T getTypeMapping(Type clientsType) {
        return (T)this.typeMapper.getJaversType(clientsType);
    }

    public <T extends ManagedType> T getTypeMapping(String typeName) {
        return (T)this.typeMapper.getJaversManagedType(typeName);
    }

    @Override
    public <T> Diff compareCollections(Collection<T> oldVersion, Collection<T> currentVersion, Class<T> itemClass) {
        return this.diffFactory.compareCollections(oldVersion, currentVersion, itemClass);
    }

    @Override
    public Property getProperty(PropertyChange propertyChange) {
        ManagedType managedType = this.typeMapper.getJaversManagedType(propertyChange.getAffectedGlobalId());
        return managedType.getProperty(propertyChange.getPropertyName());
    }
}

