/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.type;

import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.core.metamodel.clazz.EntityDefinition;
import org.javers.core.metamodel.property.Property;
import org.javers.core.metamodel.type.EntityType;
import org.javers.core.metamodel.type.ManagedClass;
import org.javers.core.metamodel.type.ManagedClassFactory;
import org.javers.core.metamodel.type.ShallowReferenceType;

class EntityTypeFactory {
    private final ManagedClassFactory managedClassFactory;

    EntityTypeFactory(ManagedClassFactory managedClassFactory) {
        this.managedClassFactory = managedClassFactory;
    }

    EntityType createEntity(EntityDefinition definition) {
        ManagedClass managedClass = this.managedClassFactory.create(definition);
        Property idProperty = definition.hasCustomId() ? managedClass.getProperty(definition.getIdPropertyName()) : this.findDefaultIdProperty(managedClass);
        if (definition.isShallowReference()) {
            return new ShallowReferenceType(managedClass, idProperty, definition.getTypeName());
        }
        return new EntityType(managedClass, idProperty, definition.getTypeName());
    }

    private Property findDefaultIdProperty(ManagedClass managedClass) {
        if (managedClass.getLooksLikeId().isEmpty()) {
            throw new JaversException(JaversExceptionCode.ENTITY_WITHOUT_ID, managedClass.getBaseJavaClass().getName());
        }
        return managedClass.getLooksLikeId().get(0);
    }
}

