/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.json;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.TypeAdapter;
import java.lang.reflect.Type;
import java.util.Collection;
import org.javers.common.validation.Validate;
import org.javers.core.json.AtomicTypeAdapter;
import org.javers.core.json.JsonConverter;
import org.javers.core.json.JsonTypeAdapter;
import org.javers.core.json.typeadapter.date.DateTypeCoreAdapters;
import org.javers.core.metamodel.annotation.DiffIgnore;

public class JsonConverterBuilder {
    private static final String ISO_DATE_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ssZ";
    private boolean typeSafeValues = false;
    private boolean prettyPrint = true;
    private final GsonBuilder gsonBuilder = new GsonBuilder();

    public JsonConverterBuilder() {
        this.gsonBuilder.setExclusionStrategies(new ExclusionStrategy[]{new SkipFieldExclusionStrategy()});
    }

    public JsonConverterBuilder typeSafeValues(boolean typeSafeValues) {
        this.typeSafeValues = typeSafeValues;
        return this;
    }

    public JsonConverterBuilder prettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
        return this;
    }

    public JsonConverterBuilder registerNativeTypeAdapter(Type targetType, TypeAdapter nativeAdapter) {
        Validate.argumentsAreNotNull(targetType, nativeAdapter);
        this.gsonBuilder.registerTypeAdapter(targetType, (Object)nativeAdapter);
        return this;
    }

    public JsonConverterBuilder registerNativeGsonSerializer(Type targetType, JsonSerializer<?> jsonSerializer) {
        Validate.argumentsAreNotNull(targetType, jsonSerializer);
        this.gsonBuilder.registerTypeAdapter(targetType, jsonSerializer);
        return this;
    }

    public JsonConverterBuilder registerNativeGsonDeserializer(Type targetType, JsonDeserializer<?> jsonDeserializer) {
        Validate.argumentsAreNotNull(targetType, jsonDeserializer);
        this.gsonBuilder.registerTypeAdapter(targetType, jsonDeserializer);
        return this;
    }

    public JsonConverterBuilder registerJsonTypeAdapters(Collection<JsonTypeAdapter> adapters) {
        Validate.argumentIsNotNull(adapters);
        for (JsonTypeAdapter adapter : adapters) {
            this.registerJsonTypeAdapter(adapter);
        }
        return this;
    }

    public JsonConverterBuilder registerJsonTypeAdapter(JsonTypeAdapter adapter) {
        Validate.argumentIsNotNull(adapter);
        for (Class c : adapter.getValueTypes()) {
            this.registerJsonTypeAdapterForType(c, adapter);
        }
        return this;
    }

    public JsonConverter build() {
        this.registerJsonTypeAdapters(DateTypeCoreAdapters.adapters());
        this.registerJsonTypeAdapter(new AtomicTypeAdapter(this.typeSafeValues));
        if (this.prettyPrint) {
            this.gsonBuilder.setPrettyPrinting();
        }
        this.gsonBuilder.serializeNulls().setDateFormat(ISO_DATE_TIME_FORMAT);
        return new JsonConverter(this.gsonBuilder.create());
    }

    private void registerJsonTypeAdapterForType(Type targetType, final JsonTypeAdapter adapter) {
        JsonSerializer jsonSerializer = new JsonSerializer(){

            public JsonElement serialize(Object value, Type type, JsonSerializationContext jsonSerializationContext) {
                return adapter.toJson(value, jsonSerializationContext);
            }
        };
        JsonDeserializer jsonDeserializer = new JsonDeserializer(){

            public Object deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
                return adapter.fromJson(jsonElement, jsonDeserializationContext);
            }
        };
        this.registerNativeGsonSerializer(targetType, jsonSerializer);
        this.registerNativeGsonDeserializer(targetType, jsonDeserializer);
    }

    private static class SkipFieldExclusionStrategy
    implements ExclusionStrategy {
        private SkipFieldExclusionStrategy() {
        }

        public boolean shouldSkipClass(Class<?> clazz) {
            return clazz.getAnnotation(DiffIgnore.class) != null;
        }

        public boolean shouldSkipField(FieldAttributes field) {
            return field.getAnnotation(DiffIgnore.class) != null;
        }
    }
}

