/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core;

import com.google.gson.TypeAdapter;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.javers.common.date.DateProvider;
import org.javers.common.date.DefaultDateProvider;
import org.javers.common.reflection.ReflectionUtil;
import org.javers.common.validation.Validate;
import org.javers.core.AbstractContainerBuilder;
import org.javers.core.CommitIdGenerator;
import org.javers.core.CoreJaversModule;
import org.javers.core.Javers;
import org.javers.core.JaversCore;
import org.javers.core.JaversCoreConfiguration;
import org.javers.core.MappingStyle;
import org.javers.core.commit.CommitFactoryModule;
import org.javers.core.diff.DiffFactoryModule;
import org.javers.core.diff.ListCompareAlgorithm;
import org.javers.core.diff.appenders.DiffAppendersModule;
import org.javers.core.diff.custom.CustomPropertyComparator;
import org.javers.core.diff.custom.CustomToNativeAppenderAdapter;
import org.javers.core.graph.GraphFactoryModule;
import org.javers.core.graph.ObjectAccessHook;
import org.javers.core.graph.TailoredJaversMemberFactoryModule;
import org.javers.core.json.JsonConverter;
import org.javers.core.json.JsonConverterBuilder;
import org.javers.core.json.JsonTypeAdapter;
import org.javers.core.json.typeadapter.change.ChangeTypeAdaptersModule;
import org.javers.core.json.typeadapter.commit.CommitTypeAdaptersModule;
import org.javers.core.json.typeadapter.util.UtilTypeAdapters;
import org.javers.core.metamodel.annotation.TypeName;
import org.javers.core.metamodel.clazz.ClientsClassDefinition;
import org.javers.core.metamodel.clazz.CustomDefinition;
import org.javers.core.metamodel.clazz.EntityDefinition;
import org.javers.core.metamodel.clazz.IgnoredTypeDefinition;
import org.javers.core.metamodel.clazz.ValueDefinition;
import org.javers.core.metamodel.clazz.ValueObjectDefinition;
import org.javers.core.metamodel.scanner.ScannerModule;
import org.javers.core.metamodel.type.TypeMapper;
import org.javers.core.metamodel.type.TypeMapperModule;
import org.javers.core.snapshot.SnapshotModule;
import org.javers.groovysupport.GroovyAddOns;
import org.javers.java8support.Java8AddOns;
import org.javers.mongosupport.MongoLong64JsonDeserializer;
import org.javers.mongosupport.RequiredMongoSupportPredicate;
import org.javers.repository.api.JaversExtendedRepository;
import org.javers.repository.api.JaversRepository;
import org.javers.repository.inmemory.InMemoryRepositoryModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaversBuilder
extends AbstractContainerBuilder {
    private static final Logger logger = LoggerFactory.getLogger(JaversBuilder.class);
    private final Set<ClientsClassDefinition> clientsClassDefinitions = new HashSet<ClientsClassDefinition>();
    private final Set<Class> classesToScan = new HashSet<Class>();
    private JaversRepository repository;
    private DateProvider dateProvider;
    private long bootStart = System.currentTimeMillis();

    public static JaversBuilder javers() {
        return new JaversBuilder();
    }

    protected JaversBuilder() {
        logger.debug("starting up JaVers ...");
        this.bootContainer();
        this.addModule(new CoreJaversModule(this.getContainer()));
        this.addModule(new DiffFactoryModule());
        this.addModule(new CommitFactoryModule(this.getContainer()));
        this.addModule(new SnapshotModule(this.getContainer()));
        this.addModule(new GraphFactoryModule(this.getContainer()));
        if (ReflectionUtil.isJava8runtime()) {
            new Java8AddOns().beforeAssemble(this);
        }
        new GroovyAddOns().beforeAssemble(this);
        new UtilTypeAdapters().beforeAssemble(this);
    }

    public Javers build() {
        Javers javers = this.assembleJaversInstance();
        this.repository.ensureSchema();
        long boot = System.currentTimeMillis() - this.bootStart;
        logger.info("JaVers instance started in {} ms", (Object)boot);
        return javers;
    }

    protected Javers assembleJaversInstance() {
        this.addModule(new DiffAppendersModule(this.coreConfiguration(), this.getContainer()));
        this.addModule(new TailoredJaversMemberFactoryModule(this.coreConfiguration(), this.getContainer()));
        this.addModule(new ScannerModule(this.coreConfiguration(), this.getContainer()));
        this.bootManagedTypeModule();
        this.bootJsonConverter();
        this.bootDateTimeProvider();
        this.bootRepository();
        for (Class c : this.classesToScan) {
            this.typeMapper().getJaversType(c);
        }
        return this.getContainerComponent(JaversCore.class);
    }

    public JaversBuilder registerJaversRepository(JaversRepository repository) {
        Validate.argumentsAreNotNull(repository);
        this.repository = repository;
        return this;
    }

    public JaversBuilder registerEntity(Class<?> entityClass) {
        Validate.argumentIsNotNull(entityClass);
        return this.registerEntity(new EntityDefinition(entityClass));
    }

    public JaversBuilder registerValueObject(Class<?> valueObjectClass) {
        Validate.argumentIsNotNull(valueObjectClass);
        this.clientsClassDefinitions.add(new ValueObjectDefinition(valueObjectClass));
        return this;
    }

    public JaversBuilder registerEntity(EntityDefinition entityDefinition) {
        Validate.argumentIsNotNull(entityDefinition);
        this.clientsClassDefinitions.add(entityDefinition);
        return this;
    }

    public JaversBuilder registerValueObject(ValueObjectDefinition valueObjectDefinition) {
        Validate.argumentIsNotNull(valueObjectDefinition);
        this.clientsClassDefinitions.add(valueObjectDefinition);
        return this;
    }

    public JaversBuilder withPackagesToScan(String packagesToScan) {
        if (packagesToScan == null || packagesToScan.trim().isEmpty()) {
            return this;
        }
        long start = System.currentTimeMillis();
        logger.info("scanning package(s): {}", (Object)packagesToScan);
        List<Class<?>> scan = ReflectionUtil.findClasses(TypeName.class, packagesToScan.replaceAll(" ", "").split(","));
        for (Class<?> c : scan) {
            this.scanTypeName(c);
        }
        long delta = System.currentTimeMillis() - start;
        logger.info("found {} ManagedClasse(s) with @TypeName in {} ms", (Object)scan.size(), (Object)delta);
        return this;
    }

    public JaversBuilder scanTypeName(Class userType) {
        this.classesToScan.add(userType);
        return this;
    }

    public JaversBuilder registerValue(Class<?> valueClass) {
        Validate.argumentIsNotNull(valueClass);
        this.clientsClassDefinitions.add(new ValueDefinition(valueClass));
        return this;
    }

    public JaversBuilder registerIgnoredClass(Class<?> ignoredClass) {
        Validate.argumentIsNotNull(ignoredClass);
        this.clientsClassDefinitions.add(new IgnoredTypeDefinition(ignoredClass));
        return this;
    }

    public JaversBuilder registerValueTypeAdapter(JsonTypeAdapter typeAdapter) {
        for (Class c : typeAdapter.getValueTypes()) {
            this.registerValue(c);
        }
        this.jsonConverterBuilder().registerJsonTypeAdapter(typeAdapter);
        return this;
    }

    public JaversBuilder registerValueGsonTypeAdapter(Class valueType, TypeAdapter nativeAdapter) {
        this.registerValue(valueType);
        this.jsonConverterBuilder().registerNativeTypeAdapter(valueType, nativeAdapter);
        return this;
    }

    public JaversBuilder withTypeSafeValues(boolean typeSafeValues) {
        this.jsonConverterBuilder().typeSafeValues(typeSafeValues);
        return this;
    }

    public JaversBuilder withPrettyPrint(boolean prettyPrint) {
        this.jsonConverterBuilder().prettyPrint(prettyPrint);
        return this;
    }

    public JaversBuilder registerEntities(Class<?> ... entityClasses) {
        for (Class<?> clazz : entityClasses) {
            this.registerEntity(clazz);
        }
        return this;
    }

    public JaversBuilder registerValueObjects(Class<?> ... valueObjectClasses) {
        for (Class<?> clazz : valueObjectClasses) {
            this.registerValueObject(clazz);
        }
        return this;
    }

    public JaversBuilder withMappingStyle(MappingStyle mappingStyle) {
        Validate.argumentIsNotNull((Object)mappingStyle);
        this.coreConfiguration().withMappingStyle(mappingStyle);
        return this;
    }

    public JaversBuilder withCommitIdGenerator(CommitIdGenerator commitIdGenerator) {
        Validate.argumentIsNotNull((Object)commitIdGenerator);
        this.coreConfiguration().withCommitIdGenerator(commitIdGenerator);
        return this;
    }

    public JaversBuilder withNewObjectsSnapshot(boolean newObjectsSnapshot) {
        this.coreConfiguration().withNewObjectsSnapshot(newObjectsSnapshot);
        return this;
    }

    public JaversBuilder withObjectAccessHook(ObjectAccessHook objectAccessHook) {
        this.removeComponent(ObjectAccessHook.class);
        this.bindComponent(ObjectAccessHook.class, objectAccessHook);
        return this;
    }

    public <T> JaversBuilder registerCustomComparator(CustomPropertyComparator<T, ?> comparator, Class<T> customType) {
        this.clientsClassDefinitions.add(new CustomDefinition(customType));
        this.bindComponent(comparator, new CustomToNativeAppenderAdapter(comparator, customType));
        return this;
    }

    public JaversBuilder withListCompareAlgorithm(ListCompareAlgorithm algorithm) {
        Validate.argumentIsNotNull((Object)algorithm);
        this.coreConfiguration().withListCompareAlgorithm(algorithm);
        return this;
    }

    public JaversBuilder withDateTimeProvider(DateProvider dateProvider) {
        Validate.argumentIsNotNull(dateProvider);
        this.dateProvider = dateProvider;
        return this;
    }

    private void mapRegisteredClasses() {
        TypeMapper typeMapper = this.typeMapper();
        for (ClientsClassDefinition def : this.clientsClassDefinitions) {
            typeMapper.registerClientsClass(def);
        }
    }

    private TypeMapper typeMapper() {
        return this.getContainerComponent(TypeMapper.class);
    }

    private JaversCoreConfiguration coreConfiguration() {
        return this.getContainerComponent(JaversCoreConfiguration.class);
    }

    private JsonConverterBuilder jsonConverterBuilder() {
        return this.getContainerComponent(JsonConverterBuilder.class);
    }

    private void bootManagedTypeModule() {
        this.addModule(new TypeMapperModule(this.getContainer()));
        this.mapRegisteredClasses();
    }

    private void bootJsonConverter() {
        JsonConverterBuilder jsonConverterBuilder = this.jsonConverterBuilder();
        this.addModule(new ChangeTypeAdaptersModule(this.getContainer()));
        this.addModule(new CommitTypeAdaptersModule(this.getContainer()));
        if (new RequiredMongoSupportPredicate().apply(this.repository)) {
            jsonConverterBuilder.registerNativeGsonDeserializer((Type)((Object)Long.class), new MongoLong64JsonDeserializer());
        }
        jsonConverterBuilder.registerJsonTypeAdapters(this.getComponents(JsonTypeAdapter.class));
        this.addComponent(jsonConverterBuilder.build());
    }

    private void bootDateTimeProvider() {
        if (this.dateProvider == null) {
            this.dateProvider = new DefaultDateProvider();
        }
        this.addComponent(this.dateProvider);
    }

    private void bootRepository() {
        if (this.repository == null) {
            logger.info("using fake InMemoryRepository, register actual implementation via JaversBuilder.registerJaversRepository()");
            this.addModule(new InMemoryRepositoryModule(this.getContainer()));
            this.repository = this.getContainerComponent(JaversRepository.class);
        } else {
            this.repository.setJsonConverter(this.getContainerComponent(JsonConverter.class));
            this.addComponent(this.repository);
        }
        this.addComponent(JaversExtendedRepository.class);
    }
}

