/*
 * Decompiled with CFR 0.152.
 */
package org.javers.common.reflection;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.javers.common.reflection.JaversMethod;
import org.javers.common.reflection.TypeResolvingContext;
import org.javers.common.string.ShaDigest;

class JaversMethodFactory {
    private final Class methodSource;

    public JaversMethodFactory(Class methodSource) {
        this.methodSource = methodSource;
    }

    public List<JaversMethod> getAllMethods() {
        ArrayList<JaversMethod> methods = new ArrayList<JaversMethod>();
        HashSet<Integer> added = new HashSet<Integer>();
        TypeResolvingContext context = new TypeResolvingContext();
        for (Class clazz = this.methodSource; clazz != null; clazz = clazz.getSuperclass()) {
            context.addTypeSubstitutions(clazz);
            for (Method m : clazz.getDeclaredMethods()) {
                int methodKey;
                if (m.isBridge() || added.contains(methodKey = JaversMethodFactory.methodKey(m))) continue;
                methods.add(this.createJMethod(m, context));
                added.add(methodKey);
            }
        }
        return methods;
    }

    private JaversMethod createJMethod(Method rawMethod, TypeResolvingContext context) {
        Type actualReturnType = context.getSubstitution(rawMethod.getGenericReturnType());
        return new JaversMethod(rawMethod, actualReturnType);
    }

    public static int methodKey(Method m) {
        int key = ShaDigest.shortDigest(m.getName());
        for (Class<?> c : m.getParameterTypes()) {
            key += c.hashCode();
        }
        return key;
    }
}

