/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.javers.common.collections.Function;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.repository.api.SnapshotIdentifier;

class PreviousSnapshotsCalculator {
    private final Function<Collection<SnapshotIdentifier>, List<CdoSnapshot>> snapshotProvider;

    PreviousSnapshotsCalculator(Function<Collection<SnapshotIdentifier>, List<CdoSnapshot>> snapshotProvider) {
        this.snapshotProvider = snapshotProvider;
    }

    Map<SnapshotIdentifier, CdoSnapshot> calculate(List<CdoSnapshot> snapshots) {
        HashMap<SnapshotIdentifier, CdoSnapshot> previousSnapshots = new HashMap<SnapshotIdentifier, CdoSnapshot>();
        this.populatePreviousSnapshotsWithSnapshots(previousSnapshots, snapshots);
        List<CdoSnapshot> missingPreviousSnapshots = this.getMissingPreviousSnapshots(snapshots, previousSnapshots);
        this.populatePreviousSnapshotsWithSnapshots(previousSnapshots, missingPreviousSnapshots);
        return previousSnapshots;
    }

    private List<CdoSnapshot> getSnapshots(Collection<SnapshotIdentifier> identifiers) {
        return this.snapshotProvider.apply(identifiers);
    }

    private void populatePreviousSnapshotsWithSnapshots(Map<SnapshotIdentifier, CdoSnapshot> previousSnapshots, List<CdoSnapshot> snapshots) {
        for (CdoSnapshot snapshot : snapshots) {
            previousSnapshots.put(SnapshotIdentifier.from(snapshot), snapshot);
        }
    }

    private List<CdoSnapshot> getMissingPreviousSnapshots(List<CdoSnapshot> snapshots, Map<SnapshotIdentifier, CdoSnapshot> previousSnapshots) {
        List<SnapshotIdentifier> missingPreviousSnapshotIdentifiers = this.determineMissingPreviousSnapshotIdentifiers(previousSnapshots, snapshots);
        return this.getSnapshots(missingPreviousSnapshotIdentifiers);
    }

    private List<SnapshotIdentifier> determineMissingPreviousSnapshotIdentifiers(Map<SnapshotIdentifier, CdoSnapshot> previousSnapshots, List<CdoSnapshot> snapshots) {
        ArrayList<SnapshotIdentifier> missingPreviousSnapshotIdentifiers = new ArrayList<SnapshotIdentifier>();
        for (CdoSnapshot snapshot : snapshots) {
            SnapshotIdentifier previousSnapshotIdentifier;
            if (snapshot.isInitial() || snapshot.isTerminal() || previousSnapshots.containsKey(previousSnapshotIdentifier = SnapshotIdentifier.from(snapshot).previous())) continue;
            missingPreviousSnapshotIdentifiers.add(previousSnapshotIdentifier);
        }
        return missingPreviousSnapshotIdentifiers;
    }
}

