/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.jql;

import java.util.List;
import org.javers.common.collections.Optional;
import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.common.validation.Validate;
import org.javers.repository.api.QueryParams;
import org.javers.repository.jql.AnyDomainObjectFilter;
import org.javers.repository.jql.ClassFilter;
import org.javers.repository.jql.Filter;
import org.javers.repository.jql.GlobalIdDTO;
import org.javers.repository.jql.IdFilter;
import org.javers.repository.jql.InstanceIdDTO;
import org.javers.repository.jql.VoOwnerFilter;

public class JqlQuery {
    private final QueryParams queryParams;
    private final List<Filter> filters;

    JqlQuery(List<Filter> filters, QueryParams queryParams) {
        Validate.argumentsAreNotNull(filters);
        this.queryParams = queryParams;
        this.filters = filters;
        this.validate();
    }

    private void validate() {
        if (this.queryParams.isAggregate() && !this.isClassQuery() && !this.isInstanceIdQuery()) {
            throw new JaversException(JaversExceptionCode.MALFORMED_JQL, "aggregate filter can be enabled only for byClass and byInstanceId queries");
        }
    }

    public String toString() {
        return "JqlQuery{queryParams=" + this.queryParams + ", filters=" + this.filters + '}';
    }

    QueryParams getQueryParams() {
        return this.queryParams;
    }

    boolean hasFilter(Class<? extends Filter> ofType) {
        return this.getFilter(ofType).isPresent();
    }

    Class getClassFilter() {
        return this.getFilter(ClassFilter.class).get().getRequiredClass();
    }

    GlobalIdDTO getIdFilter() {
        return this.getFilter(IdFilter.class).get().getGlobalId();
    }

    String getChangedProperty() {
        return this.queryParams.changedProperty().get();
    }

    VoOwnerFilter getVoOwnerFilter() {
        return this.getFilter(VoOwnerFilter.class).get();
    }

    <T extends Filter> Optional<T> getFilter(Class<T> ofType) {
        for (Filter f : this.filters) {
            if (!f.getClass().equals(ofType)) continue;
            return Optional.of(f);
        }
        return Optional.empty();
    }

    public boolean isNewObjectChanges() {
        return this.queryParams.newObjectChanges();
    }

    boolean isAnyDomainObjectQuery() {
        return this.hasFilter(AnyDomainObjectFilter.class);
    }

    boolean isIdQuery() {
        return this.hasFilter(IdFilter.class);
    }

    boolean hasChangedPropertyFilter() {
        return this.queryParams.changedProperty().isPresent();
    }

    boolean isClassQuery() {
        return this.hasFilter(ClassFilter.class);
    }

    boolean isInstanceIdQuery() {
        return this.hasFilter(IdFilter.class) && this.getIdFilter() instanceof InstanceIdDTO;
    }

    boolean isVoOwnerQuery() {
        return this.hasFilter(VoOwnerFilter.class);
    }
}

