/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.object;

import org.javers.common.validation.Validate;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.type.EntityType;

public class ValueObjectId
extends GlobalId {
    private final GlobalId ownerId;
    private final String fragment;

    public ValueObjectId(String typeName, GlobalId ownerId, String fragment) {
        super(typeName);
        Validate.argumentsAreNotNull(ownerId, fragment);
        this.ownerId = ownerId;
        this.fragment = fragment;
    }

    public String getFragment() {
        return this.fragment;
    }

    public boolean hasOwnerOfType(EntityType entityType) {
        return this.ownerId.getTypeName().equals(entityType.getName());
    }

    public GlobalId getOwnerId() {
        return this.ownerId;
    }

    @Override
    public String value() {
        return this.getOwnerId().value() + "#" + this.fragment;
    }
}

