/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.json.typeadapter.commit;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.HashMap;
import java.util.Map;

class CommitPropertiesConverter {
    private static final String PROPERTY_KEY_FIELD = "key";
    private static final String PROPERTY_VALUE_FIELD = "value";

    CommitPropertiesConverter() {
    }

    static Map<String, String> fromJson(JsonElement json) {
        HashMap<String, String> properties = new HashMap<String, String>();
        if (json != null) {
            for (JsonElement jsonElement : json.getAsJsonArray()) {
                JsonObject propertyObject = jsonElement.getAsJsonObject();
                String key = propertyObject.get(PROPERTY_KEY_FIELD).getAsString();
                String value = propertyObject.get(PROPERTY_VALUE_FIELD).getAsString();
                properties.put(key, value);
            }
        }
        return properties;
    }

    static JsonElement toJson(Map<String, String> properties) {
        JsonArray propertiesArray = new JsonArray();
        if (properties != null) {
            for (Map.Entry<String, String> metadata : properties.entrySet()) {
                JsonObject propertyObject = new JsonObject();
                propertyObject.add(PROPERTY_KEY_FIELD, (JsonElement)new JsonPrimitive(metadata.getKey()));
                propertyObject.add(PROPERTY_VALUE_FIELD, (JsonElement)new JsonPrimitive(metadata.getValue()));
                propertiesArray.add((JsonElement)propertyObject);
            }
        }
        return propertiesArray;
    }
}

