/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.commit;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.javers.common.string.ToStringBuilder;
import org.javers.common.validation.Validate;
import org.javers.core.commit.CommitId;
import org.joda.time.LocalDateTime;

public class CommitMetadata
implements Serializable {
    private final String author;
    private final Map<String, String> properties;
    private final LocalDateTime commitDate;
    private final CommitId id;

    public CommitMetadata(String author, Map<String, String> properties, LocalDateTime commitDate, CommitId id) {
        Validate.argumentsAreNotNull(author, properties, commitDate, id);
        this.author = author;
        this.properties = new HashMap<String, String>(properties);
        this.commitDate = commitDate;
        this.id = id;
    }

    public String getAuthor() {
        return this.author;
    }

    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public LocalDateTime getCommitDate() {
        return this.commitDate;
    }

    public CommitId getId() {
        return this.id;
    }

    public String toString() {
        return ToStringBuilder.toString(this, "author", this.author, "properties", this.properties, "date", this.commitDate, "id", this.id);
    }
}

