/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.graph;

import java.util.List;
import org.javers.common.collections.Predicate;
import org.javers.common.validation.Validate;
import org.javers.core.graph.CdoFactory;
import org.javers.core.graph.EdgeBuilder;
import org.javers.core.graph.LiveGraph;
import org.javers.core.graph.MultiEdge;
import org.javers.core.graph.NodeReuser;
import org.javers.core.graph.ObjectNode;
import org.javers.core.graph.SingleEdge;
import org.javers.core.metamodel.object.Cdo;
import org.javers.core.metamodel.property.Property;
import org.javers.core.metamodel.type.ContainerType;
import org.javers.core.metamodel.type.EnumerableType;
import org.javers.core.metamodel.type.JaversType;
import org.javers.core.metamodel.type.ManagedType;
import org.javers.core.metamodel.type.MapType;
import org.javers.core.metamodel.type.TypeMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ObjectGraphBuilder {
    private static final Logger logger = LoggerFactory.getLogger(ObjectGraphBuilder.class);
    private final TypeMapper typeMapper;
    private boolean built;
    private final EdgeBuilder edgeBuilder;
    private final NodeReuser nodeReuser = new NodeReuser();

    public ObjectGraphBuilder(TypeMapper typeMapper, CdoFactory cdoFactory) {
        Validate.argumentsAreNotNull(typeMapper, cdoFactory);
        this.typeMapper = typeMapper;
        this.edgeBuilder = new EdgeBuilder(typeMapper, this.nodeReuser, cdoFactory);
    }

    public LiveGraph buildGraph(Object handle) {
        Validate.argumentIsNotNull(handle);
        Cdo cdo = this.edgeBuilder.asCdo(handle, null);
        return this.buildGraphFromCdo(cdo);
    }

    LiveGraph buildGraphFromCdo(Cdo cdo) {
        Validate.argumentIsNotNull(cdo);
        ObjectNode root = this.edgeBuilder.buildNodeStub(cdo);
        while (this.nodeReuser.hasMoreStubs()) {
            ObjectNode stub = this.nodeReuser.pollStub();
            this.buildEdges(stub);
        }
        logger.debug("{} graph assembled, object nodes: {}, entities: {}, valueObjects: {}", new Object[]{this.edgeBuilder.graphType(), this.nodeReuser.nodesCount(), this.nodeReuser.entitiesCount(), this.nodeReuser.voCount()});
        this.switchToBuilt();
        return new LiveGraph(root, this.nodeReuser.nodes());
    }

    private void buildEdges(ObjectNode nodeStub) {
        this.nodeReuser.saveForReuse(nodeStub);
        this.buildSingleEdges(nodeStub);
        this.buildMultiEdges(nodeStub);
    }

    private void buildSingleEdges(ObjectNode node) {
        for (Property singleRef : this.getSingleReferencesWithManagedTypes(node.getManagedType())) {
            if (node.isNull(singleRef)) continue;
            SingleEdge edge = this.edgeBuilder.buildSingleEdge(node, singleRef);
            node.addEdge(edge);
        }
    }

    private void buildMultiEdges(ObjectNode node) {
        for (Property containerProperty : this.getNonEmptyEnumerablesWithManagedTypes(node)) {
            EnumerableType enumerableType = (EnumerableType)this.typeMapper.getPropertyType(containerProperty);
            MultiEdge multiEdge = this.edgeBuilder.createMultiEdge(containerProperty, enumerableType, node);
            node.addEdge(multiEdge);
        }
    }

    private void switchToBuilt() {
        if (this.built) {
            throw new IllegalStateException("ObjectGraphBuilder is a stateful builder (not a Service)");
        }
        this.built = true;
    }

    private List<Property> getSingleReferencesWithManagedTypes(ManagedType managedType) {
        return managedType.getProperties(new Predicate<Property>(){

            @Override
            public boolean apply(Property property) {
                Object javersType = ObjectGraphBuilder.this.typeMapper.getPropertyType(property);
                return javersType instanceof ManagedType;
            }
        });
    }

    private List<Property> getNonEmptyEnumerablesWithManagedTypes(final ObjectNode node) {
        return node.getManagedType().getProperties(new Predicate<Property>(){

            @Override
            public boolean apply(Property property) {
                Object javersType = ObjectGraphBuilder.this.typeMapper.getPropertyType(property);
                if (!(javersType instanceof EnumerableType)) {
                    return false;
                }
                EnumerableType enumerableType = (EnumerableType)javersType;
                Object container = node.getPropertyValue(property);
                if (enumerableType.isEmpty(container)) {
                    return false;
                }
                if (node.isNull(property)) {
                    return false;
                }
                return ObjectGraphBuilder.this.isContainerOfManagedTypes(enumerableType) || ObjectGraphBuilder.this.isMapWithManagedTypes(enumerableType);
            }
        });
    }

    private boolean isContainerOfManagedTypes(JaversType javersType) {
        if (!(javersType instanceof ContainerType)) {
            return false;
        }
        return this.isItemManagedType((ContainerType)javersType);
    }

    private boolean isItemManagedType(ContainerType containerType) {
        return this.typeMapper.getJaversType(containerType.getItemType()) instanceof ManagedType;
    }

    private boolean isMapWithManagedTypes(EnumerableType enumerableType) {
        if (!(enumerableType instanceof MapType)) {
            return false;
        }
        MapType mapType = (MapType)enumerableType;
        JaversType keyType = this.typeMapper.getJaversType(mapType.getKeyType());
        JaversType valueType = this.typeMapper.getJaversType(mapType.getValueType());
        return keyType instanceof ManagedType || valueType instanceof ManagedType;
    }
}

