/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.object;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.javers.common.collections.Arrays;
import org.javers.common.collections.Defaults;
import org.javers.common.collections.Sets;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.property.Property;

public class CdoSnapshotState {
    private final Map<String, Object> properties;

    CdoSnapshotState(Map<String, Object> state) {
        Validate.argumentIsNotNull(state);
        this.properties = state;
    }

    int size() {
        return this.properties.size();
    }

    public Object getPropertyValue(Property property) {
        Validate.argumentIsNotNull(property);
        Object val = this.properties.get(property.getName());
        if (val == null) {
            return Defaults.defaultValue(property.getGenericType());
        }
        return val;
    }

    public Object getPropertyValue(String propertyName) {
        Validate.argumentIsNotNull(propertyName);
        return this.properties.get(propertyName);
    }

    boolean isNull(String propertyName) {
        Validate.argumentIsNotNull(propertyName);
        return !this.properties.containsKey(propertyName);
    }

    public Set<String> getProperties() {
        return Collections.unmodifiableSet(this.properties.keySet());
    }

    public boolean equals(Object o) {
        if (!(o instanceof CdoSnapshotState)) {
            return false;
        }
        CdoSnapshotState that = (CdoSnapshotState)o;
        if (this.properties.size() != that.properties.size()) {
            return false;
        }
        for (String pName : this.properties.keySet()) {
            if (this.propertyEquals(that, pName)) continue;
            return false;
        }
        return true;
    }

    private boolean propertyEquals(CdoSnapshotState that, String propertyName) {
        Object thisValue = this.getPropertyValue(propertyName);
        Object thatValue = that.getPropertyValue(propertyName);
        if (thisValue == null || thatValue == null) {
            return false;
        }
        if (thisValue.getClass().isArray()) {
            return Arrays.equals(thisValue, thatValue);
        }
        return thisValue.equals(thatValue);
    }

    public List<String> differentValues(CdoSnapshotState previous) {
        ArrayList<String> different = new ArrayList<String>();
        for (String propertyName : this.properties.keySet()) {
            if (previous.isNull(propertyName) || this.propertyEquals(previous, propertyName)) continue;
            different.add(propertyName);
        }
        different.addAll(Sets.xor(this.properties.keySet(), previous.properties.keySet()));
        return different;
    }

    public int hashCode() {
        return this.properties.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        String prefix = "";
        for (String propertyKey : this.getSortedPropertyKeys()) {
            stringBuilder.append(prefix).append(propertyKey).append(":").append(this.getPropertyValue(propertyKey));
            prefix = ", ";
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    private List<String> getSortedPropertyKeys() {
        ArrayList<String> propertyList = new ArrayList<String>(this.properties.keySet());
        Collections.sort(propertyList);
        return propertyList;
    }
}

