/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.json.typeadapter.date;

import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.javers.common.collections.Lists;
import org.javers.core.json.JsonTypeAdapter;
import org.javers.core.json.typeadapter.date.JavaSqlDateTypeAdapter;
import org.javers.core.json.typeadapter.date.JavaSqlTimeTypeAdapter;
import org.javers.core.json.typeadapter.date.JavaSqlTimestampTypeAdapter;
import org.javers.core.json.typeadapter.date.JavaUtilDateTypeAdapter;
import org.javers.core.json.typeadapter.date.LocalDateTimeTypeAdapter;
import org.javers.core.json.typeadapter.date.LocalDateTypeAdapter;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class DateTypeCoreAdapters {
    public static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    private static final DateTimeFormatter ISO_DATE_TIME_FORMATTER = ISODateTimeFormat.dateHourMinuteSecondMillis();
    private static final DateTimeFormatter ISO_DATE_TIME_FORMATTER_LEGACY = ISODateTimeFormat.dateHourMinuteSecond();

    public static String serialize(LocalDateTime date) {
        return ISO_DATE_TIME_FORMATTER.print((ReadablePartial)date);
    }

    public static String serialize(DateTime date) {
        return ISO_DATE_TIME_FORMATTER.print((ReadableInstant)date);
    }

    public static String serializeToLocal(Date date) {
        return DateTypeCoreAdapters.serialize(new DateTime(date.getTime()));
    }

    public static String serialize(Date date) {
        return DateTypeCoreAdapters.serialize(new DateTime(date.getTime(), DateTimeZone.UTC));
    }

    public static LocalDateTime deserialize(String serializedValue) {
        if (serializedValue == null) {
            return null;
        }
        if (serializedValue.length() == 19) {
            return ISO_DATE_TIME_FORMATTER_LEGACY.parseLocalDateTime(serializedValue);
        }
        return ISO_DATE_TIME_FORMATTER.parseLocalDateTime(serializedValue);
    }

    public static List<JsonTypeAdapter> adapters() {
        return Lists.immutableListOf(new LocalDateTimeTypeAdapter(), new LocalDateTypeAdapter(), new JavaUtilDateTypeAdapter(), new JavaSqlDateTypeAdapter(), new JavaSqlTimestampTypeAdapter(), new JavaSqlTimeTypeAdapter());
    }
}

