/*
 * Decompiled with CFR 0.152.
 */
package org.javers.common.reflection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.javers.common.collections.Lists;
import org.javers.common.collections.Optional;
import org.javers.common.collections.Primitives;
import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.common.reflection.ArgumentResolver;
import org.javers.common.reflection.JaversField;
import org.javers.common.reflection.JaversFieldFactory;
import org.javers.common.reflection.JaversMethod;
import org.javers.common.reflection.JaversMethodFactory;
import org.javers.common.validation.Validate;
import org.javers.core.Javers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectionUtil {
    private static final Logger logger = LoggerFactory.getLogger(ReflectionUtil.class);

    public static boolean isJava8runtime() {
        return ReflectionUtil.isClassPresent("java.time.LocalDate");
    }

    public static boolean isClassPresent(String className) {
        try {
            Class.forName(className, false, Javers.class.getClassLoader());
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    public static Class classForName(String className) {
        try {
            return Class.forName(className, false, Javers.class.getClassLoader());
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Object invokeGetter(Object target, String getterName) {
        Validate.argumentsAreNotNull(target, getterName);
        try {
            Method m = target.getClass().getMethod(getterName, new Class[0]);
            return m.invoke(target, new Object[0]);
        }
        catch (Exception e) {
            throw new JaversException(e);
        }
    }

    public static Object newInstance(Class clazz, ArgumentResolver resolver) {
        Validate.argumentIsNotNull(clazz);
        for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
            if (ReflectionUtil.isPrivate(constructor) || ReflectionUtil.isProtected(constructor)) continue;
            Class<?>[] types = constructor.getParameterTypes();
            Object[] params = new Object[types.length];
            for (int i = 0; i < types.length; ++i) {
                try {
                    params[i] = resolver.resolve(types[i]);
                    continue;
                }
                catch (JaversException e) {
                    logger.error("failed to create new instance of " + clazz.getName() + ", argument resolver for arg[" + i + "] " + types[i].getName() + " thrown exception: " + e.getMessage());
                    throw e;
                }
            }
            try {
                constructor.setAccessible(true);
                return constructor.newInstance(params);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        throw new JaversException(JaversExceptionCode.NO_PUBLIC_CONSTRUCTOR, clazz.getName());
    }

    public static List<JaversField> getAllPersistentFields(Class methodSource) {
        ArrayList<JaversField> result = new ArrayList<JaversField>();
        for (JaversField field : ReflectionUtil.getAllFields(methodSource)) {
            if (!ReflectionUtil.isPersistentField((Field)field.getRawMember())) continue;
            result.add(field);
        }
        return result;
    }

    public static List<JaversMethod> findAllPersistentGetters(Class methodSource) {
        ArrayList<JaversMethod> result = new ArrayList<JaversMethod>();
        for (JaversMethod m : ReflectionUtil.getAllMethods(methodSource)) {
            if (!ReflectionUtil.isPersistentGetter((Method)m.getRawMember())) continue;
            result.add(m);
        }
        return result;
    }

    public static List<JaversMethod> getAllMethods(Class methodSource) {
        JaversMethodFactory methodFactory = new JaversMethodFactory(methodSource);
        return methodFactory.getAllMethods();
    }

    public static List<JaversField> getAllFields(Class<?> methodSource) {
        JaversFieldFactory fieldFactory = new JaversFieldFactory(methodSource);
        return fieldFactory.getAllFields();
    }

    public static boolean isPersistentGetter(Method m) {
        if (!ReflectionUtil.isGetter(m)) {
            return false;
        }
        return !Modifier.isStatic(m.getModifiers()) && !Modifier.isAbstract(m.getModifiers()) && !Modifier.isNative(m.getModifiers());
    }

    public static boolean isPersistentField(Field field) {
        return !Modifier.isTransient(field.getModifiers()) && !Modifier.isStatic(field.getModifiers()) && !field.getName().equals("this$0");
    }

    public static boolean isGetter(Method m) {
        return (m.getName().startsWith("get") || m.getName().startsWith("is")) && m.getParameterTypes().length == 0;
    }

    private static boolean isPrivate(Member member) {
        return Modifier.isPrivate(member.getModifiers());
    }

    private static boolean isProtected(Member member) {
        return Modifier.isProtected(member.getModifiers());
    }

    public static List<Type> getAllTypeArguments(Type javaType) {
        if (!(javaType instanceof ParameterizedType)) {
            return Collections.emptyList();
        }
        return Lists.immutableListOf(((ParameterizedType)javaType).getActualTypeArguments());
    }

    public static Optional<Type> isConcreteType(Type javaType) {
        WildcardType wildcardType;
        if (javaType instanceof Class || javaType instanceof ParameterizedType) {
            return Optional.of(javaType);
        }
        if (javaType instanceof WildcardType && (wildcardType = (WildcardType)javaType).getLowerBounds().length == 0) {
            for (Type type : wildcardType.getUpperBounds()) {
                if (type instanceof Class && ((Class)type).equals(Object.class)) continue;
                return Optional.of(type);
            }
        }
        return Optional.empty();
    }

    public static Class extractClass(Type javaType) {
        if (javaType instanceof ParameterizedType && ((ParameterizedType)javaType).getRawType() instanceof Class) {
            return (Class)((ParameterizedType)javaType).getRawType();
        }
        if (javaType instanceof Class) {
            return (Class)javaType;
        }
        throw new JaversException(JaversExceptionCode.CLASS_EXTRACTION_ERROR, javaType);
    }

    public static boolean isAnnotationPresentInHierarchy(Class<?> clazz, Class<? extends Annotation> ann) {
        for (Class<?> current = clazz; current != null && current != Object.class; current = current.getSuperclass()) {
            if (!current.isAnnotationPresent(ann)) continue;
            return true;
        }
        return false;
    }

    public static int calculateHierarchyDistance(Class<?> clazz, Class<?> parent) {
        Class<?> current = clazz;
        int distance = 0;
        while (current != null) {
            if (parent == current) {
                return distance;
            }
            for (Class<?> interf : current.getInterfaces()) {
                if (parent != interf) continue;
                return distance + 1;
            }
            current = current.getSuperclass();
            ++distance;
        }
        return Integer.MAX_VALUE;
    }

    public static String reflectiveToString(Object cdoId) {
        if (cdoId == null) {
            return "";
        }
        if (cdoId instanceof String) {
            return (String)cdoId;
        }
        if (cdoId instanceof BigDecimal) {
            return cdoId.toString();
        }
        if (Primitives.isPrimitiveOrBox(cdoId)) {
            return cdoId.toString();
        }
        StringBuilder ret = new StringBuilder();
        for (JaversField f : ReflectionUtil.getAllPersistentFields(cdoId.getClass())) {
            Object val = f.invokeEvenIfPrivate(cdoId);
            if (val != null) {
                ret.append(val.toString());
            }
            ret.append(",");
        }
        if (ret.length() == 0) {
            return cdoId.toString();
        }
        ret.delete(ret.length() - 1, ret.length());
        return ret.toString();
    }
}

