/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.clazz;

import java.util.List;
import org.javers.common.collections.Optional;
import org.javers.core.metamodel.clazz.ClientsClassDefinition;
import org.javers.core.metamodel.clazz.EntityDefinitionBuilder;

public class EntityDefinition
extends ClientsClassDefinition {
    private final Optional<String> idPropertyName;
    private final boolean shallowReference;

    public EntityDefinition(Class<?> entity) {
        this(new EntityDefinitionBuilder(entity));
    }

    public EntityDefinition(Class<?> entity, String idPropertyName) {
        this(new EntityDefinitionBuilder(entity).withIdPropertyName(idPropertyName));
    }

    EntityDefinition(EntityDefinitionBuilder builder) {
        super(builder);
        this.idPropertyName = builder.getIdPropertyName();
        this.shallowReference = builder.isShallowReference();
    }

    @Deprecated
    public EntityDefinition(Class<?> entity, String idPropertyName, List<String> ignoredProperties) {
        this((EntityDefinitionBuilder)new EntityDefinitionBuilder(entity).withIdPropertyName(idPropertyName).withIgnoredProperties(ignoredProperties));
    }

    public boolean hasCustomId() {
        return this.idPropertyName.isPresent();
    }

    public String getIdPropertyName() {
        return this.idPropertyName.get();
    }

    public boolean isShallowReference() {
        return this.shallowReference;
    }
}

