/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.jql;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.common.validation.Validate;
import org.javers.core.commit.CommitId;
import org.javers.repository.api.QueryParams;
import org.javers.repository.api.QueryParamsBuilder;
import org.javers.repository.jql.ClassFilter;
import org.javers.repository.jql.Filter;
import org.javers.repository.jql.GlobalIdDTO;
import org.javers.repository.jql.IdFilter;
import org.javers.repository.jql.InstanceIdDTO;
import org.javers.repository.jql.JqlQuery;
import org.javers.repository.jql.PropertyFilter;
import org.javers.repository.jql.ValueObjectIdDTO;
import org.javers.repository.jql.VoOwnerFilter;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;

public class QueryBuilder {
    private static final int DEFAULT_LIMIT = 100;
    private static final int DEFAULT_SKIP = 0;
    private int limit = 100;
    private int skip = 0;
    private LocalDateTime from;
    private LocalDateTime to;
    private boolean newObjectChanges;
    private CommitId commitId;
    private Long version;
    private final List<Filter> filters = new ArrayList<Filter>();

    private QueryBuilder(Filter initialFilter) {
        this.addFilter(initialFilter);
    }

    public static QueryBuilder byClass(Class requiredClass) {
        return new QueryBuilder(new ClassFilter(requiredClass));
    }

    public static QueryBuilder byInstanceId(Object localId, Class entityClass) {
        Validate.argumentsAreNotNull(localId, entityClass);
        return new QueryBuilder(new IdFilter(InstanceIdDTO.instanceId(localId, entityClass)));
    }

    public static QueryBuilder byValueObject(Class ownerEntityClass, String path) {
        Validate.argumentsAreNotNull(ownerEntityClass, path);
        return new QueryBuilder(new VoOwnerFilter(ownerEntityClass, path));
    }

    public static QueryBuilder byValueObjectId(Object ownerLocalId, Class ownerEntityClass, String path) {
        Validate.argumentsAreNotNull(ownerEntityClass, ownerLocalId, path);
        return new QueryBuilder(new IdFilter(ValueObjectIdDTO.valueObjectId(ownerLocalId, ownerEntityClass, path)));
    }

    @Deprecated
    public static QueryBuilder byGlobalIdDTO(GlobalIdDTO globalId) {
        Validate.argumentIsNotNull(globalId);
        return new QueryBuilder(new IdFilter(globalId));
    }

    public QueryBuilder andProperty(String propertyName) {
        Validate.argumentIsNotNull(propertyName);
        this.addFilter(new PropertyFilter(propertyName));
        return this;
    }

    public QueryBuilder withNewObjectChanges(boolean newObjectChanges) {
        this.newObjectChanges = newObjectChanges;
        return this;
    }

    public QueryBuilder withNewObjectChanges() {
        this.newObjectChanges = true;
        return this;
    }

    public QueryBuilder limit(int limit) {
        this.limit = limit;
        return this;
    }

    public QueryBuilder skip(int skip) {
        this.skip = skip;
        return this;
    }

    public QueryBuilder from(LocalDateTime from) {
        this.from = from;
        return this;
    }

    public QueryBuilder from(LocalDate fromDate) {
        return this.from(fromDate.toLocalDateTime(LocalTime.MIDNIGHT));
    }

    public QueryBuilder to(LocalDateTime to) {
        this.to = to;
        return this;
    }

    public QueryBuilder to(LocalDate toDate) {
        return this.to(toDate.toLocalDateTime(LocalTime.MIDNIGHT));
    }

    public QueryBuilder withCommitId(CommitId commitId) {
        Validate.argumentIsNotNull(commitId);
        this.commitId = commitId;
        return this;
    }

    public QueryBuilder withCommitId(BigDecimal commitId) {
        Validate.argumentIsNotNull(commitId);
        return this.withCommitId(CommitId.valueOf(commitId));
    }

    public QueryBuilder withVersion(long version) {
        Validate.argumentCheck(version > 0L, "Version is not a positive number.");
        this.version = version;
        return this;
    }

    protected void addFilter(Filter filter) {
        this.filters.add(filter);
    }

    protected List<Filter> getFilters() {
        return Collections.unmodifiableList(this.filters);
    }

    protected QueryParams getQueryParams() {
        return QueryParamsBuilder.withLimit(this.limit).skip(this.skip).from(this.from).to(this.to).commitId(this.commitId).version(this.version).build();
    }

    public JqlQuery build() {
        if (this.filters.isEmpty()) {
            throw new JaversException(JaversExceptionCode.RUNTIME_EXCEPTION, "empty JqlQuery");
        }
        return new JqlQuery(this.getFilters(), this.newObjectChanges, this.getQueryParams());
    }
}

