/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.diff.appenders;

import java.lang.reflect.Type;
import org.javers.core.diff.appenders.PropertyChangeAppender;
import org.javers.core.diff.changetype.PropertyChange;
import org.javers.core.metamodel.property.Property;
import org.javers.core.metamodel.type.JaversType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CorePropertyChangeAppender<T extends PropertyChange>
implements PropertyChangeAppender<T> {
    private static final Logger logger = LoggerFactory.getLogger(CorePropertyChangeAppender.class);
    public static final String GENERIC_TYPE_NOT_PARAMETRIZED = "GENERIC_TYPE_NOT_PARAMETRIZED";

    @Override
    public int priority() {
        return 2;
    }

    protected void renderNotParametrizedWarningIfNeeded(Type parameterType, String parameterName, String colType, Property property) {
        if (parameterType == JaversType.DEFAULT_TYPE_PARAMETER) {
            this.printNotParametrizedWarning(parameterName, colType, property);
        }
    }

    private void printNotParametrizedWarning(String parameterName, String colType, Property property) {
        logger.warn("Unknown {} type in {} property: {}. Defaulting to {}, see {}.{}", new Object[]{parameterName, colType, property.toString(), JaversType.DEFAULT_TYPE_PARAMETER.getSimpleName(), CorePropertyChangeAppender.class.getSimpleName(), GENERIC_TYPE_NOT_PARAMETRIZED});
    }
}

