/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.diff.changetype;

import org.javers.common.collections.Optional;
import org.javers.common.string.ToStringBuilder;
import org.javers.core.diff.changetype.PropertyChange;
import org.javers.core.metamodel.object.GlobalId;

public final class ReferenceChange
extends PropertyChange {
    private final GlobalId left;
    private final GlobalId right;
    private final transient Optional<Object> leftObject;
    private final transient Optional<Object> rightObject;

    public ReferenceChange(GlobalId affectedCdoId, String propertyName, GlobalId leftReference, GlobalId rightReference) {
        this(affectedCdoId, propertyName, leftReference, rightReference, null, null);
    }

    public ReferenceChange(GlobalId affectedCdoId, String propertyName, GlobalId leftReference, GlobalId rightReference, Object leftObject, Object rightObject) {
        super(affectedCdoId, propertyName);
        this.left = leftReference;
        this.right = rightReference;
        this.leftObject = Optional.fromNullable(leftObject);
        this.rightObject = Optional.fromNullable(rightObject);
    }

    public GlobalId getLeft() {
        return this.left;
    }

    public GlobalId getRight() {
        return this.right;
    }

    public Optional<Object> getLeftObject() {
        return this.leftObject;
    }

    public Optional<Object> getRightObject() {
        return this.rightObject;
    }

    @Override
    protected String fieldsToString() {
        return super.fieldsToString() + ToStringBuilder.addField("oldRef", this.left) + ToStringBuilder.addField("newRef", this.right);
    }
}

