/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.property;

import java.util.ArrayList;
import java.util.List;
import org.javers.common.reflection.JaversMethod;
import org.javers.common.reflection.ReflectionUtil;
import org.javers.core.metamodel.annotation.AnnotationNamesProvider;
import org.javers.core.metamodel.property.Property;
import org.javers.core.metamodel.property.PropertyScan;
import org.javers.core.metamodel.property.PropertyScanner;

class BeanBasedPropertyScanner
implements PropertyScanner {
    private final AnnotationNamesProvider annotationNamesProvider;

    public BeanBasedPropertyScanner(AnnotationNamesProvider annotationNamesProvider) {
        this.annotationNamesProvider = annotationNamesProvider;
    }

    @Override
    public PropertyScan scan(Class<?> managedClass) {
        List<JaversMethod> getters = ReflectionUtil.findAllPersistentGetters(managedClass);
        ArrayList<Property> beanProperties = new ArrayList<Property>();
        for (JaversMethod getter : getters) {
            boolean hasTransientAnn = getter.hasAnyAnnotation(this.annotationNamesProvider.getTransientAliases());
            beanProperties.add(new Property(getter, hasTransientAnn));
        }
        return new PropertyScan(beanProperties);
    }
}

