/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.diff.appenders;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.javers.common.collections.Sets;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.core.diff.NodePair;
import org.javers.core.diff.appenders.CorePropertyChangeAppender;
import org.javers.core.diff.changetype.container.ContainerElementChange;
import org.javers.core.diff.changetype.container.SetChange;
import org.javers.core.diff.changetype.container.ValueAdded;
import org.javers.core.diff.changetype.container.ValueRemoved;
import org.javers.core.metamodel.object.DehydrateContainerFunction;
import org.javers.core.metamodel.object.GlobalIdFactory;
import org.javers.core.metamodel.object.OwnerContext;
import org.javers.core.metamodel.property.Property;
import org.javers.core.metamodel.type.ContainerType;
import org.javers.core.metamodel.type.JaversType;
import org.javers.core.metamodel.type.SetType;
import org.javers.core.metamodel.type.TypeMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SetChangeAppender
extends CorePropertyChangeAppender<SetChange> {
    private static final Logger logger = LoggerFactory.getLogger(SetChangeAppender.class);
    private final TypeMapper typeMapper;
    private final GlobalIdFactory globalIdFactory;

    SetChangeAppender(TypeMapper typeMapper, GlobalIdFactory globalIdFactory) {
        this.typeMapper = typeMapper;
        this.globalIdFactory = globalIdFactory;
    }

    @Override
    public boolean supports(JaversType propertyType) {
        return propertyType instanceof SetType;
    }

    private boolean isSupportedContainer(Property property) {
        ContainerType propertyType = (ContainerType)this.typeMapper.getPropertyType(property);
        if (this.typeMapper.isValueObject(propertyType.getItemType())) {
            logger.error("could not diff " + property + ", " + JaversExceptionCode.SET_OF_VO_DIFF_NOT_IMPLEMENTED.getMessage());
            return false;
        }
        return true;
    }

    private List<ContainerElementChange> calculateEntryChanges(SetType setType, Set leftRawSet, Set rightRawSet, OwnerContext owner) {
        JaversType itemType = this.typeMapper.getJaversType(setType.getItemType());
        DehydrateContainerFunction dehydrateFunction = new DehydrateContainerFunction(itemType, this.globalIdFactory);
        if (Objects.equals(leftRawSet, rightRawSet)) {
            return Collections.EMPTY_LIST;
        }
        Set leftSet = (Set)setType.map(leftRawSet, dehydrateFunction, owner);
        Set rightSet = (Set)setType.map(rightRawSet, dehydrateFunction, owner);
        ArrayList<ContainerElementChange> changes = new ArrayList<ContainerElementChange>();
        for (Object globalCdoId : Sets.difference(leftSet, rightSet)) {
            changes.add(new ValueRemoved(globalCdoId));
        }
        for (Object globalCdoId : Sets.difference(rightSet, leftSet)) {
            changes.add(new ValueAdded(globalCdoId));
        }
        return changes;
    }

    @Override
    public SetChange calculateChanges(NodePair pair, Property property) {
        OwnerContext owner;
        Set leftValues = (Set)pair.getLeftPropertyValue(property);
        Set rightValues = (Set)pair.getRightPropertyValue(property);
        if (!this.isSupportedContainer(property)) {
            return null;
        }
        SetType setType = (SetType)this.typeMapper.getPropertyType(property);
        List<ContainerElementChange> entryChanges = this.calculateEntryChanges(setType, leftValues, rightValues, owner = new OwnerContext(pair.getGlobalId(), property.getName()));
        if (!entryChanges.isEmpty()) {
            return new SetChange(pair.getGlobalId(), property.getName(), entryChanges);
        }
        return null;
    }
}

