/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core;

import org.javers.common.validation.Validate;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.object.GlobalIdFactory;
import org.javers.core.metamodel.object.InstanceId;
import org.javers.core.metamodel.object.UnboundedValueObjectId;
import org.javers.core.metamodel.object.ValueObjectId;

public class IdBuilder {
    private final GlobalIdFactory globalIdFactory;
    private GlobalId owner;

    public IdBuilder(GlobalIdFactory globalIdFactory) {
        this.globalIdFactory = globalIdFactory;
    }

    public IdBuilder withUnboundedOwner(Class ownerValueObjectClass) {
        this.owner = this.unboundedValueObjectId(ownerValueObjectClass);
        return this;
    }

    public IdBuilder withOwner(Object localId, Class ownerEntityClass) {
        this.owner = this.instanceId(localId, ownerEntityClass);
        return this;
    }

    public ValueObjectId voId(String path) {
        Validate.conditionFulfilled(this.owner != null, "call withOwner() first");
        return this.globalIdFactory.createValueObjectIdFromPath(this.owner, path);
    }

    public InstanceId instanceId(Object instance) {
        Validate.argumentsAreNotNull(instance);
        return (InstanceId)this.globalIdFactory.createId(instance, null);
    }

    public UnboundedValueObjectId unboundedValueObjectId(Class valueObjectClass) {
        Validate.argumentsAreNotNull(valueObjectClass);
        return this.globalIdFactory.createUnboundedValueObjectId(valueObjectClass);
    }

    public InstanceId instanceId(Object localId, Class entityClass) {
        Validate.argumentsAreNotNull(localId, entityClass);
        return this.globalIdFactory.createInstanceId(localId, entityClass);
    }
}

