/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.api;

import org.javers.common.collections.Optional;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadablePartial;

public class QueryParams {
    private final int limit;
    private final int skip;
    private final Optional<LocalDateTime> from;
    private final Optional<LocalDateTime> to;

    QueryParams(int limit, int skip, LocalDateTime from, LocalDateTime to) {
        this.limit = limit;
        this.skip = skip;
        this.from = Optional.fromNullable(from);
        this.to = Optional.fromNullable(to);
    }

    public int limit() {
        return this.limit;
    }

    public int skip() {
        return this.skip;
    }

    public boolean hasDates() {
        return this.from.isPresent() || this.to.isPresent();
    }

    public boolean isDateInRange(LocalDateTime date) {
        if (this.from.isPresent() && this.from.get().isAfter((ReadablePartial)date)) {
            return false;
        }
        return !this.to.isPresent() || !this.to.get().isBefore((ReadablePartial)date);
    }

    public Optional<LocalDateTime> from() {
        return this.from;
    }

    public Optional<LocalDateTime> to() {
        return this.to;
    }

    public String toString() {
        return "QueryParams{limit=" + this.limit + ", skip=" + this.skip + ", from=" + this.from + ", to=" + this.to + '}';
    }
}

