/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.property;

import java.util.Collection;
import org.javers.common.collections.Lists;
import org.javers.core.JaversCoreConfiguration;
import org.javers.core.MappingStyle;
import org.javers.core.metamodel.property.BeanBasedPropertyScanner;
import org.javers.core.metamodel.property.FieldBasedPropertyScanner;
import org.javers.core.pico.InstantiatingModule;
import org.picocontainer.MutablePicoContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyScannerModule
extends InstantiatingModule {
    private static final Logger logger = LoggerFactory.getLogger(PropertyScannerModule.class);
    private final JaversCoreConfiguration coreConfiguration;

    public PropertyScannerModule(MutablePicoContainer container, JaversCoreConfiguration coreConfiguration) {
        super(container);
        this.coreConfiguration = coreConfiguration;
    }

    @Override
    protected Collection<Class> getImplementations() {
        MappingStyle mappingStyle = this.coreConfiguration.getMappingStyle();
        logger.info("using " + mappingStyle.name() + " mappingStyle");
        if (mappingStyle == MappingStyle.BEAN) {
            return Lists.asList(BeanBasedPropertyScanner.class);
        }
        if (mappingStyle == MappingStyle.FIELD) {
            return Lists.asList(FieldBasedPropertyScanner.class);
        }
        throw new RuntimeException("not implementation for " + (Object)((Object)mappingStyle));
    }
}

