/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.type;

import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.List;
import org.javers.common.collections.EnumerableFunction;
import org.javers.common.collections.Lists;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.object.OwnerContext;
import org.javers.core.metamodel.type.ContainerType;
import org.javers.core.metamodel.type.IndexableContext;

public class ArrayType
extends ContainerType {
    public ArrayType(Type baseJavaType) {
        super(baseJavaType);
    }

    @Override
    public boolean isFullyParametrized() {
        return true;
    }

    @Override
    public List<Type> getActualTypeArguments() {
        return Lists.immutableListOf(this.getBaseJavaClass().getComponentType());
    }

    @Override
    public Object map(Object sourceArray, EnumerableFunction mapFunction, OwnerContext owner) {
        Validate.argumentsAreNotNull(sourceArray, mapFunction, owner);
        int len = Array.getLength(sourceArray);
        Object targetArray = this.getItemClass().isPrimitive() ? Array.newInstance(this.getItemClass(), len) : new Object[len];
        IndexableContext indexableContext = new IndexableContext();
        owner.setEnumeratorContext(indexableContext);
        for (int i = 0; i < len; ++i) {
            Object sourceVal = Array.get(sourceArray, i);
            Array.set(targetArray, i, mapFunction.apply(sourceVal, owner));
            indexableContext.incIndex();
        }
        return targetArray;
    }

    @Override
    public boolean isEmpty(Object array) {
        return array == null || Array.getLength(array) == 0;
    }
}

