/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.diff.appenders;

import java.util.Objects;
import org.javers.common.collections.Function;
import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.core.diff.NodePair;
import org.javers.core.diff.appenders.CorePropertyChangeAppender;
import org.javers.core.diff.changetype.PropertyChange;
import org.javers.core.diff.changetype.ReferenceChange;
import org.javers.core.diff.changetype.ValueChange;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.object.GlobalIdFactory;
import org.javers.core.metamodel.property.Property;
import org.javers.core.metamodel.type.JaversType;
import org.javers.core.metamodel.type.ManagedType;
import org.javers.core.metamodel.type.OptionalType;
import org.javers.core.metamodel.type.PrimitiveOrValueType;
import org.javers.core.metamodel.type.TypeMapper;

public class OptionalChangeAppender
extends CorePropertyChangeAppender<PropertyChange> {
    private final GlobalIdFactory globalIdFactory;
    private final TypeMapper typeMapper;

    public OptionalChangeAppender(GlobalIdFactory globalIdFactory, TypeMapper typeMapper) {
        this.globalIdFactory = globalIdFactory;
        this.typeMapper = typeMapper;
    }

    @Override
    public boolean supports(JaversType propertyType) {
        return propertyType instanceof OptionalType;
    }

    @Override
    public PropertyChange calculateChanges(NodePair pair, Property property) {
        OptionalType optionalType = (OptionalType)this.typeMapper.getPropertyType(property);
        JaversType contentType = this.typeMapper.getJaversType(optionalType.getItemType());
        Object leftOptional = optionalType.normalize(pair.getLeftPropertyValue(property));
        Object rightOptional = optionalType.normalize(pair.getRightPropertyValue(property));
        if (contentType instanceof ManagedType) {
            GlobalId rightId;
            GlobalId leftId = this.getAndDehydrate(optionalType, leftOptional, contentType);
            if (Objects.equals(leftId, rightId = this.getAndDehydrate(optionalType, rightOptional, contentType))) {
                return null;
            }
            return new ReferenceChange(pair.getGlobalId(), property.getName(), leftId, rightId);
        }
        if (contentType instanceof PrimitiveOrValueType) {
            if (Objects.equals(leftOptional, rightOptional)) {
                return null;
            }
            return new ValueChange(pair.getGlobalId(), property.getName(), leftOptional, rightOptional);
        }
        throw new JaversException(JaversExceptionCode.UNSUPPORTED_OPTIONAL_CONTENT_TYPE, contentType);
    }

    private GlobalId getAndDehydrate(OptionalType optionalType, Object optional, final JaversType contentType) {
        return (GlobalId)optionalType.mapAndGet(optional, new Function(){

            public Object apply(Object input) {
                return OptionalChangeAppender.this.globalIdFactory.dehydrate(input, contentType, null);
            }
        });
    }
}

