/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.api;

import java.util.List;
import org.javers.common.collections.Lists;
import org.javers.common.collections.Optional;
import org.javers.common.collections.Predicate;
import org.javers.common.validation.Validate;
import org.javers.core.commit.Commit;
import org.javers.core.commit.CommitId;
import org.javers.core.diff.Change;
import org.javers.core.diff.changetype.PropertyChange;
import org.javers.core.json.JsonConverter;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.type.EntityType;
import org.javers.core.metamodel.type.ManagedType;
import org.javers.core.snapshot.SnapshotDiffer;
import org.javers.repository.api.JaversRepository;

public class JaversExtendedRepository
implements JaversRepository {
    private final JaversRepository delegate;
    private final SnapshotDiffer snapshotDiffer;

    public JaversExtendedRepository(JaversRepository delegate, SnapshotDiffer snapshotDiffer) {
        this.delegate = delegate;
        this.snapshotDiffer = snapshotDiffer;
    }

    public List<Change> getPropertyChangeHistory(GlobalId globalId, String propertyName, boolean newObjects, int limit) {
        Validate.argumentsAreNotNull(globalId, propertyName);
        List<CdoSnapshot> snapshots = this.getPropertyStateHistory(globalId, propertyName, limit);
        List<Change> changes = this.snapshotDiffer.calculateDiffs(snapshots, newObjects);
        return this.filterByPropertyName(changes, propertyName);
    }

    public List<Change> getPropertyChangeHistory(ManagedType givenClass, String propertyName, boolean newObjects, int limit) {
        Validate.argumentsAreNotNull(givenClass, propertyName);
        List<CdoSnapshot> snapshots = this.getPropertyStateHistory(givenClass, propertyName, limit);
        List<Change> changes = this.snapshotDiffer.calculateMultiDiffs(snapshots, newObjects);
        return this.filterByPropertyName(changes, propertyName);
    }

    public List<Change> getChangeHistory(GlobalId globalId, boolean newObjects, int limit) {
        Validate.argumentsAreNotNull(globalId);
        List<CdoSnapshot> snapshots = this.getStateHistory(globalId, limit);
        return this.snapshotDiffer.calculateDiffs(snapshots, newObjects);
    }

    public List<Change> getChangeHistory(ManagedType givenClass, boolean newObjects, int limit) {
        Validate.argumentsAreNotNull(givenClass);
        List<CdoSnapshot> snapshots = this.getStateHistory(givenClass, limit);
        return this.snapshotDiffer.calculateMultiDiffs(snapshots, newObjects);
    }

    public List<Change> getValueObjectChangeHistory(EntityType ownerEntity, String path, boolean newObjects, int limit) {
        Validate.argumentsAreNotNull(ownerEntity, path);
        List<CdoSnapshot> snapshots = this.getValueObjectStateHistory(ownerEntity, path, limit);
        return this.snapshotDiffer.calculateMultiDiffs(snapshots, newObjects);
    }

    @Override
    public List<CdoSnapshot> getStateHistory(GlobalId globalId, int limit) {
        Validate.argumentIsNotNull(globalId);
        return this.delegate.getStateHistory(globalId, limit);
    }

    @Override
    public List<CdoSnapshot> getPropertyStateHistory(GlobalId globalId, String propertyName, int limit) {
        Validate.argumentsAreNotNull(globalId, propertyName);
        return this.delegate.getPropertyStateHistory(globalId, propertyName, limit);
    }

    @Override
    public List<CdoSnapshot> getPropertyStateHistory(ManagedType givenClass, String propertyName, int limit) {
        Validate.argumentsAreNotNull(givenClass, propertyName);
        return this.delegate.getPropertyStateHistory(givenClass, propertyName, limit);
    }

    @Override
    public List<CdoSnapshot> getValueObjectStateHistory(EntityType ownerEntity, String path, int limit) {
        Validate.argumentsAreNotNull(ownerEntity, path);
        return this.delegate.getValueObjectStateHistory(ownerEntity, path, limit);
    }

    @Override
    public Optional<CdoSnapshot> getLatest(GlobalId globalId) {
        Validate.argumentIsNotNull(globalId);
        return this.delegate.getLatest(globalId);
    }

    @Override
    public List<CdoSnapshot> getStateHistory(ManagedType givenClass, int limit) {
        return this.delegate.getStateHistory(givenClass, limit);
    }

    @Override
    public void persist(Commit commit) {
        this.delegate.persist(commit);
    }

    @Override
    public CommitId getHeadId() {
        return this.delegate.getHeadId();
    }

    @Override
    public void setJsonConverter(JsonConverter jsonConverter) {
    }

    @Override
    public void ensureSchema() {
        this.delegate.ensureSchema();
    }

    private List<Change> filterByPropertyName(List<Change> changes, final String propertyName) {
        return Lists.positiveFilter(changes, new Predicate<Change>(){

            @Override
            public boolean apply(Change input) {
                return input instanceof PropertyChange && ((PropertyChange)input).getPropertyName().equals(propertyName);
            }
        });
    }
}

