/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.type;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.javers.common.collections.Predicate;
import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.property.Property;

class ManagedClass {
    private final Class<?> baseJavaClass;
    private final Map<String, Property> propertiesByName;
    private final List<Property> managedProperties;
    private final List<Property> transientAnnProperties;

    ManagedClass(Class baseJavaClass, List<Property> allProperties) {
        Validate.argumentsAreNotNull(allProperties);
        this.baseJavaClass = baseJavaClass;
        this.managedProperties = new ArrayList<Property>();
        this.transientAnnProperties = new ArrayList<Property>();
        this.propertiesByName = new HashMap<String, Property>();
        for (Property property : allProperties) {
            if (property.isHasTransientAnn()) {
                this.transientAnnProperties.add(property);
            } else {
                this.managedProperties.add(property);
            }
            this.propertiesByName.put(property.getName(), property);
        }
    }

    List<Property> getProperties() {
        return Collections.unmodifiableList(this.managedProperties);
    }

    Set<String> getPropertyNames() {
        return Collections.unmodifiableSet(this.propertiesByName.keySet());
    }

    List<Property> getProperties(Predicate<Property> query) {
        ArrayList<Property> retProperties = new ArrayList<Property>();
        for (Property property : this.managedProperties) {
            if (!query.apply(property)) continue;
            retProperties.add(property);
        }
        return retProperties;
    }

    Property getProperty(String withName) {
        Validate.argumentIsNotNull(withName);
        if (!this.propertiesByName.containsKey(withName)) {
            throw new JaversException(JaversExceptionCode.PROPERTY_NOT_FOUND, withName, this.baseJavaClass.getName());
        }
        return this.propertiesByName.get(withName);
    }

    Class<?> getBaseJavaClass() {
        return this.baseJavaClass;
    }
}

