/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.diff;

import org.javers.common.collections.Optional;
import org.javers.common.string.ToStringBuilder;
import org.javers.common.validation.Validate;
import org.javers.core.commit.CommitMetadata;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.object.InstanceId;

public abstract class Change {
    private Optional<CommitMetadata> commitMetadata;
    private final GlobalId affectedCdoId;
    private transient Optional<Object> affectedCdo;

    protected Change(GlobalId affectedCdoId) {
        Validate.argumentsAreNotNull(affectedCdoId);
        this.affectedCdoId = affectedCdoId;
        this.commitMetadata = Optional.empty();
    }

    protected Change(GlobalId affectedCdoId, CommitMetadata commitMetadata) {
        Validate.argumentsAreNotNull(affectedCdoId, commitMetadata);
        this.affectedCdoId = affectedCdoId;
        this.commitMetadata = Optional.of(commitMetadata);
    }

    public GlobalId getAffectedGlobalId() {
        return this.affectedCdoId;
    }

    @Deprecated
    public GlobalId getAffectedCdoId() {
        return this.affectedCdoId;
    }

    public Object getAffectedLocalId() {
        if (this.affectedCdoId instanceof InstanceId) {
            return ((InstanceId)this.affectedCdoId).getCdoId();
        }
        return null;
    }

    public Optional<Object> getAffectedObject() {
        return this.affectedCdo;
    }

    public Optional<CommitMetadata> getCommitMetadata() {
        return this.commitMetadata;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + this.fieldsToString() + "}";
    }

    protected String fieldsToString() {
        return ToStringBuilder.addFirstField("globalId", this.getAffectedGlobalId());
    }

    protected void setAffectedCdo(Optional<Object> affectedCdo) {
        Validate.argumentIsNotNull(affectedCdo);
        Validate.conditionFulfilled(this.affectedCdo == null, "affectedCdo already set");
        this.affectedCdo = affectedCdo;
    }

    public void bindToCommit(CommitMetadata commitMetadata) {
        Validate.argumentIsNotNull(commitMetadata);
        if (this.commitMetadata.isPresent()) {
            throw new IllegalStateException("Change should be effectively immutable");
        }
        this.commitMetadata = Optional.of(commitMetadata);
    }
}

