/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.clazz;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.javers.common.collections.Optional;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.clazz.ClientsClassDefinitionBuilder;

public abstract class ClientsClassDefinition {
    private final Class<?> baseJavaClass;
    private final List<String> ignoredProperties;
    private final Optional<String> typeName;

    ClientsClassDefinition(Class<?> baseJavaClass) {
        this(baseJavaClass, Collections.emptyList(), Optional.empty());
    }

    ClientsClassDefinition(Class<?> baseJavaClass, List<String> ignoredProperties) {
        this(baseJavaClass, ignoredProperties, Optional.empty());
    }

    ClientsClassDefinition(ClientsClassDefinitionBuilder builder) {
        this(builder.getClazz(), builder.getIgnoredProperties(), builder.getTypeName());
    }

    private ClientsClassDefinition(Class<?> baseJavaClass, List<String> ignoredProperties, Optional<String> typeName) {
        Validate.argumentsAreNotNull(baseJavaClass, typeName, ignoredProperties);
        this.baseJavaClass = baseJavaClass;
        this.ignoredProperties = new ArrayList<String>(ignoredProperties);
        this.typeName = typeName;
    }

    public Class<?> getBaseJavaClass() {
        return this.baseJavaClass;
    }

    public boolean equals(Object o) {
        if (this == o || this.getClass() != o.getClass()) {
            return false;
        }
        ClientsClassDefinition that = (ClientsClassDefinition)o;
        return this.baseJavaClass.equals(that.baseJavaClass);
    }

    public int hashCode() {
        return this.baseJavaClass.hashCode();
    }

    public List<String> getIgnoredProperties() {
        return Collections.unmodifiableList(this.ignoredProperties);
    }

    public Optional<String> getTypeName() {
        return this.typeName;
    }

    public boolean hasTypeName() {
        return this.typeName.isPresent();
    }
}

